<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterpriseList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список предприятий.
 * @subpackage Structs
 */
class EnterpriseList extends EntityList
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Enterprise[]
     */
    public $enterprise;
    /**
     * Constructor method for EnterpriseList
     * @uses EnterpriseList::setEnterprise()
     * @param \StructType\Enterprise[] $enterprise
     */
    public function __construct(array $enterprise = array())
    {
        $this
            ->setEnterprise($enterprise);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise[]|null
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @throws \InvalidArgumentException
     * @param \StructType\Enterprise[] $enterprise
     * @return \StructType\EnterpriseList
     */
    public function setEnterprise(array $enterprise = array())
    {
        foreach ($enterprise as $enterpriseListEnterpriseItem) {
            // validation for constraint: itemType
            if (!$enterpriseListEnterpriseItem instanceof \StructType\Enterprise) {
                throw new \InvalidArgumentException(sprintf('The enterprise property can only contain items of \StructType\Enterprise, "%s" given', is_object($enterpriseListEnterpriseItem) ? get_class($enterpriseListEnterpriseItem) : gettype($enterpriseListEnterpriseItem)), __LINE__);
            }
        }
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Add item to enterprise value
     * @throws \InvalidArgumentException
     * @param \StructType\Enterprise $item
     * @return \StructType\EnterpriseList
     */
    public function addToEnterprise(\StructType\Enterprise $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Enterprise) {
            throw new \InvalidArgumentException(sprintf('The enterprise property can only contain items of \StructType\Enterprise, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->enterprise[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnterpriseList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
