<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Enterprise StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий предприятие.
 * @subpackage Structs
 */
class Enterprise extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Название предприятия. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The englishName
     * Meta informations extracted from the WSDL
     * - documentation: Название предприятия на английском языке. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $englishName;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип российского предприятия. | Тип, описывающий тип российских предприятий.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $type;
    /**
     * The numberList
     * Meta informations extracted from the WSDL
     * - documentation: Список номеров предприятия.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnterpriseNumberList
     */
    public $numberList;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес предприятия.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $address;
    /**
     * The activityList
     * Meta informations extracted from the WSDL
     * - documentation: Деятельность, осуществляемая предприятием.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnterpriseActivityList
     */
    public $activityList;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - documentation: ХС-владелец.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $owner;
    /**
     * The officialRegistration
     * Meta informations extracted from the WSDL
     * - documentation: Факт постановки на учёт в налоговом органе.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EnterpriseOfficialRegistration[]
     */
    public $officialRegistration;
    /**
     * The registryStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус предприятия в реестре ИС Цербер.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $registryStatus;
    /**
     * Constructor method for Enterprise
     * @uses Enterprise::setName()
     * @uses Enterprise::setEnglishName()
     * @uses Enterprise::setType()
     * @uses Enterprise::setNumberList()
     * @uses Enterprise::setAddress()
     * @uses Enterprise::setActivityList()
     * @uses Enterprise::setOwner()
     * @uses Enterprise::setOfficialRegistration()
     * @uses Enterprise::setRegistryStatus()
     * @param string $name
     * @param string $englishName
     * @param int $type
     * @param \StructType\EnterpriseNumberList $numberList
     * @param \StructType\Address $address
     * @param \StructType\EnterpriseActivityList $activityList
     * @param \StructType\BusinessEntity $owner
     * @param \StructType\EnterpriseOfficialRegistration[] $officialRegistration
     * @param string $registryStatus
     */
    public function __construct($name = null, $englishName = null, $type = null, \StructType\EnterpriseNumberList $numberList = null, \StructType\Address $address = null, \StructType\EnterpriseActivityList $activityList = null, \StructType\BusinessEntity $owner = null, array $officialRegistration = array(), $registryStatus = null)
    {
        $this
            ->setName($name)
            ->setEnglishName($englishName)
            ->setType($type)
            ->setNumberList($numberList)
            ->setAddress($address)
            ->setActivityList($activityList)
            ->setOwner($owner)
            ->setOfficialRegistration($officialRegistration)
            ->setRegistryStatus($registryStatus);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Enterprise
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get englishName value
     * @return string|null
     */
    public function getEnglishName()
    {
        return $this->englishName;
    }
    /**
     * Set englishName value
     * @param string $englishName
     * @return \StructType\Enterprise
     */
    public function setEnglishName($englishName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($englishName) && strlen($englishName) > 255) || (is_array($englishName) && count($englishName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($englishName) ? strlen($englishName) : count($englishName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($englishName) && !is_string($englishName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($englishName)), __LINE__);
        }
        $this->englishName = $englishName;
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \StructType\Enterprise
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get numberList value
     * @return \StructType\EnterpriseNumberList|null
     */
    public function getNumberList()
    {
        return $this->numberList;
    }
    /**
     * Set numberList value
     * @param \StructType\EnterpriseNumberList $numberList
     * @return \StructType\Enterprise
     */
    public function setNumberList(\StructType\EnterpriseNumberList $numberList = null)
    {
        $this->numberList = $numberList;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\Address $address
     * @return \StructType\Enterprise
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get activityList value
     * @return \StructType\EnterpriseActivityList|null
     */
    public function getActivityList()
    {
        return $this->activityList;
    }
    /**
     * Set activityList value
     * @param \StructType\EnterpriseActivityList $activityList
     * @return \StructType\Enterprise
     */
    public function setActivityList(\StructType\EnterpriseActivityList $activityList = null)
    {
        $this->activityList = $activityList;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\BusinessEntity|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\BusinessEntity $owner
     * @return \StructType\Enterprise
     */
    public function setOwner(\StructType\BusinessEntity $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get officialRegistration value
     * @return \StructType\EnterpriseOfficialRegistration[]|null
     */
    public function getOfficialRegistration()
    {
        return $this->officialRegistration;
    }
    /**
     * Set officialRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\EnterpriseOfficialRegistration[] $officialRegistration
     * @return \StructType\Enterprise
     */
    public function setOfficialRegistration(array $officialRegistration = array())
    {
        foreach ($officialRegistration as $enterpriseOfficialRegistrationItem) {
            // validation for constraint: itemType
            if (!$enterpriseOfficialRegistrationItem instanceof \StructType\EnterpriseOfficialRegistration) {
                throw new \InvalidArgumentException(sprintf('The officialRegistration property can only contain items of \StructType\EnterpriseOfficialRegistration, "%s" given', is_object($enterpriseOfficialRegistrationItem) ? get_class($enterpriseOfficialRegistrationItem) : gettype($enterpriseOfficialRegistrationItem)), __LINE__);
            }
        }
        $this->officialRegistration = $officialRegistration;
        return $this;
    }
    /**
     * Add item to officialRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\EnterpriseOfficialRegistration $item
     * @return \StructType\Enterprise
     */
    public function addToOfficialRegistration(\StructType\EnterpriseOfficialRegistration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EnterpriseOfficialRegistration) {
            throw new \InvalidArgumentException(sprintf('The officialRegistration property can only contain items of \StructType\EnterpriseOfficialRegistration, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->officialRegistration[] = $item;
        return $this;
    }
    /**
     * Get registryStatus value
     * @return string|null
     */
    public function getRegistryStatus()
    {
        return $this->registryStatus;
    }
    /**
     * Set registryStatus value
     * @uses \EnumType\EnterpriseStatus::valueIsValid()
     * @uses \EnumType\EnterpriseStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registryStatus
     * @return \StructType\Enterprise
     */
    public function setRegistryStatus($registryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnterpriseStatus::valueIsValid($registryStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $registryStatus, implode(', ', \EnumType\EnterpriseStatus::getValidValues())), __LINE__);
        }
        $this->registryStatus = $registryStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Enterprise
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
