<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for District StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип района региона (обычно второй уровень в адресной структуре).
 * @subpackage Structs
 */
class District extends AddressObjectView
{
    /**
     * The regionGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор рениона, к которому относится данный район. | Тип, описывающий уникальный идентификатор любой
     * сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $regionGuid;
    /**
     * Constructor method for District
     * @uses District::setRegionGuid()
     * @param string $regionGuid
     */
    public function __construct($regionGuid = null)
    {
        $this
            ->setRegionGuid($regionGuid);
    }
    /**
     * Get regionGuid value
     * @return string|null
     */
    public function getRegionGuid()
    {
        return $this->regionGuid;
    }
    /**
     * Set regionGuid value
     * @param string $regionGuid
     * @return \StructType\District
     */
    public function setRegionGuid($regionGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($regionGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $regionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($regionGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regionGuid) && !is_string($regionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionGuid)), __LINE__);
        }
        $this->regionGuid = $regionGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\District
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
