<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CertifiedBatch StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сертифицированная партия продукции.
 * @subpackage Structs
 */
class CertifiedBatch extends AbstractStructBase
{
    /**
     * The producer
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о производителе продукции. Участник, получивший производственный сертификат, собственник партии. Заполняется только
     * для производственного вет.сертификата.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessMember
     */
    public $producer;
    /**
     * The batch
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о партии продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Batch
     */
    public $batch;
    /**
     * Constructor method for CertifiedBatch
     * @uses CertifiedBatch::setProducer()
     * @uses CertifiedBatch::setBatch()
     * @param \StructType\BusinessMember $producer
     * @param \StructType\Batch $batch
     */
    public function __construct(\StructType\BusinessMember $producer = null, \StructType\Batch $batch = null)
    {
        $this
            ->setProducer($producer)
            ->setBatch($batch);
    }
    /**
     * Get producer value
     * @return \StructType\BusinessMember|null
     */
    public function getProducer()
    {
        return $this->producer;
    }
    /**
     * Set producer value
     * @param \StructType\BusinessMember $producer
     * @return \StructType\CertifiedBatch
     */
    public function setProducer(\StructType\BusinessMember $producer = null)
    {
        $this->producer = $producer;
        return $this;
    }
    /**
     * Get batch value
     * @return \StructType\Batch|null
     */
    public function getBatch()
    {
        return $this->batch;
    }
    /**
     * Set batch value
     * @param \StructType\Batch $batch
     * @return \StructType\CertifiedBatch
     */
    public function setBatch(\StructType\Batch $batch = null)
    {
        $this->batch = $batch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertifiedBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
