<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessMember StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий бизнес-сторону.
 * @subpackage Structs
 */
class BusinessMember extends AbstractStructBase
{
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - documentation: Хозяйствующий субъект
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $businessEntity;
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие (площадка)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The globalID
     * Meta informations extracted from the WSDL
     * - documentation: Global Location Number - уникальный номер площадки хозяйствующего субъекта, на которой он осуществляет деятельность. См. http://www.gs1.org/gln. |
     * Тип для представления Global Location Number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - length: 13
     * @var string[]
     */
    public $globalID;
    /**
     * Constructor method for BusinessMember
     * @uses BusinessMember::setBusinessEntity()
     * @uses BusinessMember::setEnterprise()
     * @uses BusinessMember::setGlobalID()
     * @param \StructType\BusinessEntity $businessEntity
     * @param \StructType\Enterprise $enterprise
     * @param string[] $globalID
     */
    public function __construct(\StructType\BusinessEntity $businessEntity = null, \StructType\Enterprise $enterprise = null, array $globalID = array())
    {
        $this
            ->setBusinessEntity($businessEntity)
            ->setEnterprise($enterprise)
            ->setGlobalID($globalID);
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntity|null
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\BusinessEntity $businessEntity
     * @return \StructType\BusinessMember
     */
    public function setBusinessEntity(\StructType\BusinessEntity $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise|null
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\BusinessMember
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get globalID value
     * @return string[]|null
     */
    public function getGlobalID()
    {
        return $this->globalID;
    }
    /**
     * Set globalID value
     * @throws \InvalidArgumentException
     * @param string[] $globalID
     * @return \StructType\BusinessMember
     */
    public function setGlobalID(array $globalID = array())
    {
        // validation for constraint: length
        if ((is_scalar($globalID) && strlen($globalID) !== 13) || (is_array($globalID) && count($globalID) !== 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s)', __LINE__);
        }
        foreach ($globalID as $businessMemberGlobalIDItem) {
            // validation for constraint: itemType
            if (!is_string($businessMemberGlobalIDItem)) {
                throw new \InvalidArgumentException(sprintf('The globalID property can only contain items of string, "%s" given', is_object($businessMemberGlobalIDItem) ? get_class($businessMemberGlobalIDItem) : gettype($businessMemberGlobalIDItem)), __LINE__);
            }
        }
        $this->globalID = $globalID;
        return $this;
    }
    /**
     * Add item to globalID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BusinessMember
     */
    public function addToGlobalID($item)
    {
        // validation for constraint: length
        if ((is_scalar($item) && strlen($item) !== 13) || (is_array($item) && count($item) !== 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s)', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The globalID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->globalID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
