<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchExtraInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Дополнительные сведения о партии продукции.
 * @subpackage Structs
 */
class BatchExtraInfo extends AbstractStructBase
{
    /**
     * The nonFoodSource
     * Meta informations extracted from the WSDL
     * - documentation: Вид проиcхождения для непищевой продукции, технического сырья, кормов и кормовых добавок.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nonFoodSource;
    /**
     * Constructor method for BatchExtraInfo
     * @uses BatchExtraInfo::setNonFoodSource()
     * @param string $nonFoodSource
     */
    public function __construct($nonFoodSource = null)
    {
        $this
            ->setNonFoodSource($nonFoodSource);
    }
    /**
     * Get nonFoodSource value
     * @return string|null
     */
    public function getNonFoodSource()
    {
        return $this->nonFoodSource;
    }
    /**
     * Set nonFoodSource value
     * @uses \EnumType\NonFoodProductSourceType::valueIsValid()
     * @uses \EnumType\NonFoodProductSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonFoodSource
     * @return \StructType\BatchExtraInfo
     */
    public function setNonFoodSource($nonFoodSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NonFoodProductSourceType::valueIsValid($nonFoodSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nonFoodSource, implode(', ', \EnumType\NonFoodProductSourceType::getValidValues())), __LINE__);
        }
        $this->nonFoodSource = $nonFoodSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BatchExtraInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
