<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorityList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список ролей пользователя.
 * @subpackage Structs
 */
class AuthorityList extends AbstractStructBase
{
    /**
     * The authority
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserAuthority[]
     */
    public $authority;
    /**
     * Constructor method for AuthorityList
     * @uses AuthorityList::setAuthority()
     * @param \StructType\UserAuthority[] $authority
     */
    public function __construct(array $authority = array())
    {
        $this
            ->setAuthority($authority);
    }
    /**
     * Get authority value
     * @return \StructType\UserAuthority[]|null
     */
    public function getAuthority()
    {
        return $this->authority;
    }
    /**
     * Set authority value
     * @throws \InvalidArgumentException
     * @param \StructType\UserAuthority[] $authority
     * @return \StructType\AuthorityList
     */
    public function setAuthority(array $authority = array())
    {
        foreach ($authority as $authorityListAuthorityItem) {
            // validation for constraint: itemType
            if (!$authorityListAuthorityItem instanceof \StructType\UserAuthority) {
                throw new \InvalidArgumentException(sprintf('The authority property can only contain items of \StructType\UserAuthority, "%s" given', is_object($authorityListAuthorityItem) ? get_class($authorityListAuthorityItem) : gettype($authorityListAuthorityItem)), __LINE__);
            }
        }
        $this->authority = $authority;
        return $this;
    }
    /**
     * Add item to authority value
     * @throws \InvalidArgumentException
     * @param \StructType\UserAuthority $item
     * @return \StructType\AuthorityList
     */
    public function addToAuthority(\StructType\UserAuthority $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserAuthority) {
            throw new \InvalidArgumentException(sprintf('The authority property can only contain items of \StructType\UserAuthority, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->authority[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
