<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnimalDiseaseList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список заболеваний.
 * @subpackage Structs
 */
class AnimalDiseaseList extends EntityList
{
    /**
     * The disease
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnimalDisease[]
     */
    public $disease;
    /**
     * Constructor method for AnimalDiseaseList
     * @uses AnimalDiseaseList::setDisease()
     * @param \StructType\AnimalDisease[] $disease
     */
    public function __construct(array $disease = array())
    {
        $this
            ->setDisease($disease);
    }
    /**
     * Get disease value
     * @return \StructType\AnimalDisease[]|null
     */
    public function getDisease()
    {
        return $this->disease;
    }
    /**
     * Set disease value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalDisease[] $disease
     * @return \StructType\AnimalDiseaseList
     */
    public function setDisease(array $disease = array())
    {
        foreach ($disease as $animalDiseaseListDiseaseItem) {
            // validation for constraint: itemType
            if (!$animalDiseaseListDiseaseItem instanceof \StructType\AnimalDisease) {
                throw new \InvalidArgumentException(sprintf('The disease property can only contain items of \StructType\AnimalDisease, "%s" given', is_object($animalDiseaseListDiseaseItem) ? get_class($animalDiseaseListDiseaseItem) : gettype($animalDiseaseListDiseaseItem)), __LINE__);
            }
        }
        $this->disease = $disease;
        return $this;
    }
    /**
     * Add item to disease value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalDisease $item
     * @return \StructType\AnimalDiseaseList
     */
    public function addToDisease(\StructType\AnimalDisease $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnimalDisease) {
            throw new \InvalidArgumentException(sprintf('The disease property can only contain items of \StructType\AnimalDisease, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->disease[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnimalDiseaseList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
