<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityLocationList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список методов исследований.
 * @subpackage Structs
 */
class ActivityLocationList extends EntityList
{
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessMember[]
     */
    public $location;
    /**
     * Constructor method for ActivityLocationList
     * @uses ActivityLocationList::setLocation()
     * @param \StructType\BusinessMember[] $location
     */
    public function __construct(array $location = array())
    {
        $this
            ->setLocation($location);
    }
    /**
     * Get location value
     * @return \StructType\BusinessMember[]|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessMember[] $location
     * @return \StructType\ActivityLocationList
     */
    public function setLocation(array $location = array())
    {
        foreach ($location as $activityLocationListLocationItem) {
            // validation for constraint: itemType
            if (!$activityLocationListLocationItem instanceof \StructType\BusinessMember) {
                throw new \InvalidArgumentException(sprintf('The location property can only contain items of \StructType\BusinessMember, "%s" given', is_object($activityLocationListLocationItem) ? get_class($activityLocationListLocationItem) : gettype($activityLocationListLocationItem)), __LINE__);
            }
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Add item to location value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessMember $item
     * @return \StructType\ActivityLocationList
     */
    public function addToLocation(\StructType\BusinessMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessMember) {
            throw new \InvalidArgumentException(sprintf('The location property can only contain items of \StructType\BusinessMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->location[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityLocationList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
