<?php

namespace EnumType;

/**
 * This class stands for VetDocumentType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип ветсертификата.
 * @subpackage Enumerations
 */
class VetDocumentType
{
    /**
     * Constant for value 'TRANSPORT'
     * @return string 'TRANSPORT'
     */
    const VALUE_TRANSPORT = 'TRANSPORT';
    /**
     * Constant for value 'PRODUCTIVE'
     * @return string 'PRODUCTIVE'
     */
    const VALUE_PRODUCTIVE = 'PRODUCTIVE';
    /**
     * Constant for value 'RETURNABLE'
     * @return string 'RETURNABLE'
     */
    const VALUE_RETURNABLE = 'RETURNABLE';
    /**
     * Constant for value 'INCOMING'
     * @return string 'INCOMING'
     */
    const VALUE_INCOMING = 'INCOMING';
    /**
     * Constant for value 'OUTGOING'
     * @return string 'OUTGOING'
     */
    const VALUE_OUTGOING = 'OUTGOING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSPORT
     * @uses self::VALUE_PRODUCTIVE
     * @uses self::VALUE_RETURNABLE
     * @uses self::VALUE_INCOMING
     * @uses self::VALUE_OUTGOING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSPORT,
            self::VALUE_PRODUCTIVE,
            self::VALUE_RETURNABLE,
            self::VALUE_INCOMING,
            self::VALUE_OUTGOING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
