<?php

namespace EnumType;

/**
 * This class stands for VaccinationType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Статус применения вакцины
 * @subpackage Enumerations
 */
class VaccinationType
{
    /**
     * Constant for value 'UNDEFINED'
     * @return string 'UNDEFINED'
     */
    const VALUE_UNDEFINED = 'UNDEFINED';
    /**
     * Constant for value 'APPLIED'
     * @return string 'APPLIED'
     */
    const VALUE_APPLIED = 'APPLIED';
    /**
     * Constant for value 'UNVACCINATED'
     * @return string 'UNVACCINATED'
     */
    const VALUE_UNVACCINATED = 'UNVACCINATED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_APPLIED
     * @uses self::VALUE_UNVACCINATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_APPLIED,
            self::VALUE_UNVACCINATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
