<?php

namespace EnumType;

/**
 * This class stands for EnterpriseStatus EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий статус предприятия в реестре.
 * @subpackage Enumerations
 */
class EnterpriseStatus
{
    /**
     * Constant for value 'UNVERIFIED'
     * @return string 'UNVERIFIED'
     */
    const VALUE_UNVERIFIED = 'UNVERIFIED';
    /**
     * Constant for value 'VERIFIED'
     * @return string 'VERIFIED'
     */
    const VALUE_VERIFIED = 'VERIFIED';
    /**
     * Constant for value 'CANCELED'
     * @return string 'CANCELED'
     */
    const VALUE_CANCELED = 'CANCELED';
    /**
     * Constant for value 'DELETED'
     * @return string 'DELETED'
     */
    const VALUE_DELETED = 'DELETED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNVERIFIED
     * @uses self::VALUE_VERIFIED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_DELETED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNVERIFIED,
            self::VALUE_VERIFIED,
            self::VALUE_CANCELED,
            self::VALUE_DELETED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
