<?php

namespace EnumType;

/**
 * This class stands for EnterpriseRole EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий роль пердприятия.
 * @subpackage Enumerations
 */
class EnterpriseRole
{
    /**
     * Constant for value 'UNKNOWN'
     * @return string 'UNKNOWN'
     */
    const VALUE_UNKNOWN = 'UNKNOWN';
    /**
     * Constant for value 'PRODUCER'
     * @return string 'PRODUCER'
     */
    const VALUE_PRODUCER = 'PRODUCER';
    /**
     * Constant for value 'SLAUGHTER_HOUSE'
     * @return string 'SLAUGHTER_HOUSE'
     */
    const VALUE_SLAUGHTER_HOUSE = 'SLAUGHTER_HOUSE';
    /**
     * Constant for value 'CUTTING_PLANT'
     * @return string 'CUTTING_PLANT'
     */
    const VALUE_CUTTING_PLANT = 'CUTTING_PLANT';
    /**
     * Constant for value 'COLD_STORE'
     * @return string 'COLD_STORE'
     */
    const VALUE_COLD_STORE = 'COLD_STORE';
    /**
     * Constant for value 'PACKAGING_PLANT'
     * @return string 'PACKAGING_PLANT'
     */
    const VALUE_PACKAGING_PLANT = 'PACKAGING_PLANT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PRODUCER
     * @uses self::VALUE_SLAUGHTER_HOUSE
     * @uses self::VALUE_CUTTING_PLANT
     * @uses self::VALUE_COLD_STORE
     * @uses self::VALUE_PACKAGING_PLANT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PRODUCER,
            self::VALUE_SLAUGHTER_HOUSE,
            self::VALUE_CUTTING_PLANT,
            self::VALUE_COLD_STORE,
            self::VALUE_PACKAGING_PLANT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
