<?php

namespace EnumType;

/**
 * This class stands for ApplicationStatus EnumType
 * @subpackage Enumerations
 */
class ApplicationStatus
{
    /**
     * Constant for value 'ACCEPTED'
     * @return string 'ACCEPTED'
     */
    const VALUE_ACCEPTED = 'ACCEPTED';
    /**
     * Constant for value 'IN_PROCESS'
     * @return string 'IN_PROCESS'
     */
    const VALUE_IN_PROCESS = 'IN_PROCESS';
    /**
     * Constant for value 'COMPLETED'
     * @return string 'COMPLETED'
     */
    const VALUE_COMPLETED = 'COMPLETED';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_REJECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPTED,
            self::VALUE_IN_PROCESS,
            self::VALUE_COMPLETED,
            self::VALUE_REJECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
