<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawVetDocumentRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на аннулирование ветеринарного сертификата.
 * @subpackage Structs
 */
class WithdrawVetDocumentRequest extends MercuryApplicationRequest
{
    /**
     * The vetDocumentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор аннулируемого сертификата. | Тип, описывающий уникальный идентификатор любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $vetDocumentId;
    /**
     * The withdrawReason
     * Meta informations extracted from the WSDL
     * - documentation: Причина аннулирования. | Основание изменения статуса ВСД | Строковый тип без ограничения максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $withdrawReason;
    /**
     * The withdrawDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата аннулирования.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $withdrawDate;
    /**
     * The specifiedPerson
     * Meta informations extracted from the WSDL
     * - documentation: Ветеринарный врач, ответственный за аннулирование сертификата.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $specifiedPerson;
    /**
     * Constructor method for WithdrawVetDocumentRequest
     * @uses WithdrawVetDocumentRequest::setVetDocumentId()
     * @uses WithdrawVetDocumentRequest::setWithdrawReason()
     * @uses WithdrawVetDocumentRequest::setWithdrawDate()
     * @uses WithdrawVetDocumentRequest::setSpecifiedPerson()
     * @param string $vetDocumentId
     * @param string $withdrawReason
     * @param string $withdrawDate
     * @param \StructType\User $specifiedPerson
     */
    public function __construct($vetDocumentId = null, $withdrawReason = null, $withdrawDate = null, \StructType\User $specifiedPerson = null)
    {
        $this
            ->setVetDocumentId($vetDocumentId)
            ->setWithdrawReason($withdrawReason)
            ->setWithdrawDate($withdrawDate)
            ->setSpecifiedPerson($specifiedPerson);
    }
    /**
     * Get vetDocumentId value
     * @return string
     */
    public function getVetDocumentId()
    {
        return $this->vetDocumentId;
    }
    /**
     * Set vetDocumentId value
     * @param string $vetDocumentId
     * @return \StructType\WithdrawVetDocumentRequest
     */
    public function setVetDocumentId($vetDocumentId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vetDocumentId) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $vetDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($vetDocumentId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vetDocumentId) && !is_string($vetDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vetDocumentId)), __LINE__);
        }
        $this->vetDocumentId = $vetDocumentId;
        return $this;
    }
    /**
     * Get withdrawReason value
     * @return string
     */
    public function getWithdrawReason()
    {
        return $this->withdrawReason;
    }
    /**
     * Set withdrawReason value
     * @param string $withdrawReason
     * @return \StructType\WithdrawVetDocumentRequest
     */
    public function setWithdrawReason($withdrawReason = null)
    {
        // validation for constraint: string
        if (!is_null($withdrawReason) && !is_string($withdrawReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($withdrawReason)), __LINE__);
        }
        $this->withdrawReason = $withdrawReason;
        return $this;
    }
    /**
     * Get withdrawDate value
     * @return string
     */
    public function getWithdrawDate()
    {
        return $this->withdrawDate;
    }
    /**
     * Set withdrawDate value
     * @param string $withdrawDate
     * @return \StructType\WithdrawVetDocumentRequest
     */
    public function setWithdrawDate($withdrawDate = null)
    {
        // validation for constraint: string
        if (!is_null($withdrawDate) && !is_string($withdrawDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($withdrawDate)), __LINE__);
        }
        $this->withdrawDate = $withdrawDate;
        return $this;
    }
    /**
     * Get specifiedPerson value
     * @return \StructType\User|null
     */
    public function getSpecifiedPerson()
    {
        return $this->specifiedPerson;
    }
    /**
     * Set specifiedPerson value
     * @param \StructType\User $specifiedPerson
     * @return \StructType\WithdrawVetDocumentRequest
     */
    public function setSpecifiedPerson(\StructType\User $specifiedPerson = null)
    {
        $this->specifiedPerson = $specifiedPerson;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WithdrawVetDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
