<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Waybill StructType
 * Meta informations extracted from the WSDL
 * - documentation: Товарно-транспортная накладная.
 * @subpackage Structs
 */
class Waybill extends Document
{
    /**
     * The consignor
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отправителе (владельце).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessMember
     */
    public $consignor;
    /**
     * The consignee
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о получателе груза.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessMember
     */
    public $consignee;
    /**
     * The broker
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о фирме-посреднике.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $broker;
    /**
     * The transportInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о транспорте.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransportInfo
     */
    public $transportInfo;
    /**
     * The transportStorageType
     * Meta informations extracted from the WSDL
     * - documentation: Способ хранения при перевозке.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportStorageType;
    /**
     * The shipmentRoute
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о маршруте следования (пунктах перегрузки).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipmentRoute
     */
    public $shipmentRoute;
    /**
     * Constructor method for Waybill
     * @uses Waybill::setConsignor()
     * @uses Waybill::setConsignee()
     * @uses Waybill::setBroker()
     * @uses Waybill::setTransportInfo()
     * @uses Waybill::setTransportStorageType()
     * @uses Waybill::setShipmentRoute()
     * @param \StructType\BusinessMember $consignor
     * @param \StructType\BusinessMember $consignee
     * @param \StructType\BusinessEntity $broker
     * @param \StructType\TransportInfo $transportInfo
     * @param string $transportStorageType
     * @param \StructType\ShipmentRoute $shipmentRoute
     */
    public function __construct(\StructType\BusinessMember $consignor = null, \StructType\BusinessMember $consignee = null, \StructType\BusinessEntity $broker = null, \StructType\TransportInfo $transportInfo = null, $transportStorageType = null, \StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this
            ->setConsignor($consignor)
            ->setConsignee($consignee)
            ->setBroker($broker)
            ->setTransportInfo($transportInfo)
            ->setTransportStorageType($transportStorageType)
            ->setShipmentRoute($shipmentRoute);
    }
    /**
     * Get consignor value
     * @return \StructType\BusinessMember|null
     */
    public function getConsignor()
    {
        return $this->consignor;
    }
    /**
     * Set consignor value
     * @param \StructType\BusinessMember $consignor
     * @return \StructType\Waybill
     */
    public function setConsignor(\StructType\BusinessMember $consignor = null)
    {
        $this->consignor = $consignor;
        return $this;
    }
    /**
     * Get consignee value
     * @return \StructType\BusinessMember|null
     */
    public function getConsignee()
    {
        return $this->consignee;
    }
    /**
     * Set consignee value
     * @param \StructType\BusinessMember $consignee
     * @return \StructType\Waybill
     */
    public function setConsignee(\StructType\BusinessMember $consignee = null)
    {
        $this->consignee = $consignee;
        return $this;
    }
    /**
     * Get broker value
     * @return \StructType\BusinessEntity|null
     */
    public function getBroker()
    {
        return $this->broker;
    }
    /**
     * Set broker value
     * @param \StructType\BusinessEntity $broker
     * @return \StructType\Waybill
     */
    public function setBroker(\StructType\BusinessEntity $broker = null)
    {
        $this->broker = $broker;
        return $this;
    }
    /**
     * Get transportInfo value
     * @return \StructType\TransportInfo|null
     */
    public function getTransportInfo()
    {
        return $this->transportInfo;
    }
    /**
     * Set transportInfo value
     * @param \StructType\TransportInfo $transportInfo
     * @return \StructType\Waybill
     */
    public function setTransportInfo(\StructType\TransportInfo $transportInfo = null)
    {
        $this->transportInfo = $transportInfo;
        return $this;
    }
    /**
     * Get transportStorageType value
     * @return string|null
     */
    public function getTransportStorageType()
    {
        return $this->transportStorageType;
    }
    /**
     * Set transportStorageType value
     * @uses \EnumType\TransportationStorageType::valueIsValid()
     * @uses \EnumType\TransportationStorageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportStorageType
     * @return \StructType\Waybill
     */
    public function setTransportStorageType($transportStorageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransportationStorageType::valueIsValid($transportStorageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportStorageType, implode(', ', \EnumType\TransportationStorageType::getValidValues())), __LINE__);
        }
        $this->transportStorageType = $transportStorageType;
        return $this;
    }
    /**
     * Get shipmentRoute value
     * @return \StructType\ShipmentRoute|null
     */
    public function getShipmentRoute()
    {
        return $this->shipmentRoute;
    }
    /**
     * Set shipmentRoute value
     * @param \StructType\ShipmentRoute $shipmentRoute
     * @return \StructType\Waybill
     */
    public function setShipmentRoute(\StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this->shipmentRoute = $shipmentRoute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Waybill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
