<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VetDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ветеринарный сопроводительный документ.
 * @subpackage Structs
 */
class VetDocument extends Document
{
    /**
     * The vetDForm
     * Meta informations extracted from the WSDL
     * - documentation: Форма ВСД.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vetDForm;
    /**
     * The vetDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ВСД.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vetDType;
    /**
     * The vetDStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус ВСД на момент подписания.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vetDStatus;
    /**
     * The finalized
     * Meta informations extracted from the WSDL
     * - documentation: Флаг того, что сертификат закрыт. Имеет смысл только для производственных сертификатов в статусе "Оформлен" (CONFIRMED). В случае
     * незавершенного производства оформленный производственный сертификат остаётся незакрытым до момента завершения производства (до
     * завершения производственной транзакции).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $finalized;
    /**
     * The lastUpdateDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время последнего обновления сертификата. Дата обновления изменяется при изменении статуса сертификата, а также при
     * обновлении объёма производственного сертификата в случае незавершенного производства.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastUpdateDate;
    /**
     * The certifiedBatch
     * Meta informations extracted from the WSDL
     * - documentation: Сертифицированная партия. Элемент заполняется для производственного сертификата.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CertifiedBatch
     */
    public $certifiedBatch;
    /**
     * The certifiedConsignment
     * Meta informations extracted from the WSDL
     * - documentation: Сертифицированная партия. Элемент заполняется для транспортного сертификата.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CertifiedConsignment
     */
    public $certifiedConsignment;
    /**
     * The authentication
     * Meta informations extracted from the WSDL
     * - documentation: Результаты осмотра/исследований партии. Заключение ветеринарного врача/специалиста.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VeterinaryAuthentication
     */
    public $authentication;
    /**
     * The precedingVetDocuments
     * Meta informations extracted from the WSDL
     * - documentation: DEPRECATED. Сведения о предыдущих ветеринарных сопроводительных документах. Поле не используется на запись, вместо него
     * см.referencedDocument. Используется для отображения информации о предыдущих документах в старых версиях ВСД (или ВСД, оформленных через web). |
     * Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $precedingVetDocuments;
    /**
     * The referencedDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о документах, связанных с данным сертификатом.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReferencedDocument[]
     */
    public $referencedDocument;
    /**
     * The statusChange
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об установлении статуса ветеринарного документа.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocumentStatusChange[]
     */
    public $statusChange;
    /**
     * Constructor method for VetDocument
     * @uses VetDocument::setVetDForm()
     * @uses VetDocument::setVetDType()
     * @uses VetDocument::setVetDStatus()
     * @uses VetDocument::setFinalized()
     * @uses VetDocument::setLastUpdateDate()
     * @uses VetDocument::setCertifiedBatch()
     * @uses VetDocument::setCertifiedConsignment()
     * @uses VetDocument::setAuthentication()
     * @uses VetDocument::setPrecedingVetDocuments()
     * @uses VetDocument::setReferencedDocument()
     * @uses VetDocument::setStatusChange()
     * @param string $vetDForm
     * @param string $vetDType
     * @param string $vetDStatus
     * @param bool $finalized
     * @param string $lastUpdateDate
     * @param \StructType\CertifiedBatch $certifiedBatch
     * @param \StructType\CertifiedConsignment $certifiedConsignment
     * @param \StructType\VeterinaryAuthentication $authentication
     * @param string $precedingVetDocuments
     * @param \StructType\ReferencedDocument[] $referencedDocument
     * @param \StructType\VetDocumentStatusChange[] $statusChange
     */
    public function __construct($vetDForm = null, $vetDType = null, $vetDStatus = null, $finalized = null, $lastUpdateDate = null, \StructType\CertifiedBatch $certifiedBatch = null, \StructType\CertifiedConsignment $certifiedConsignment = null, \StructType\VeterinaryAuthentication $authentication = null, $precedingVetDocuments = null, array $referencedDocument = array(), array $statusChange = array())
    {
        $this
            ->setVetDForm($vetDForm)
            ->setVetDType($vetDType)
            ->setVetDStatus($vetDStatus)
            ->setFinalized($finalized)
            ->setLastUpdateDate($lastUpdateDate)
            ->setCertifiedBatch($certifiedBatch)
            ->setCertifiedConsignment($certifiedConsignment)
            ->setAuthentication($authentication)
            ->setPrecedingVetDocuments($precedingVetDocuments)
            ->setReferencedDocument($referencedDocument)
            ->setStatusChange($statusChange);
    }
    /**
     * Get vetDForm value
     * @return string|null
     */
    public function getVetDForm()
    {
        return $this->vetDForm;
    }
    /**
     * Set vetDForm value
     * @uses \EnumType\VetDocumentForm::valueIsValid()
     * @uses \EnumType\VetDocumentForm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDForm
     * @return \StructType\VetDocument
     */
    public function setVetDForm($vetDForm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentForm::valueIsValid($vetDForm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDForm, implode(', ', \EnumType\VetDocumentForm::getValidValues())), __LINE__);
        }
        $this->vetDForm = $vetDForm;
        return $this;
    }
    /**
     * Get vetDType value
     * @return string|null
     */
    public function getVetDType()
    {
        return $this->vetDType;
    }
    /**
     * Set vetDType value
     * @uses \EnumType\VetDocumentType::valueIsValid()
     * @uses \EnumType\VetDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDType
     * @return \StructType\VetDocument
     */
    public function setVetDType($vetDType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentType::valueIsValid($vetDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDType, implode(', ', \EnumType\VetDocumentType::getValidValues())), __LINE__);
        }
        $this->vetDType = $vetDType;
        return $this;
    }
    /**
     * Get vetDStatus value
     * @return string|null
     */
    public function getVetDStatus()
    {
        return $this->vetDStatus;
    }
    /**
     * Set vetDStatus value
     * @uses \EnumType\VetDocumentStatus::valueIsValid()
     * @uses \EnumType\VetDocumentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDStatus
     * @return \StructType\VetDocument
     */
    public function setVetDStatus($vetDStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentStatus::valueIsValid($vetDStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDStatus, implode(', ', \EnumType\VetDocumentStatus::getValidValues())), __LINE__);
        }
        $this->vetDStatus = $vetDStatus;
        return $this;
    }
    /**
     * Get finalized value
     * @return bool|null
     */
    public function getFinalized()
    {
        return $this->finalized;
    }
    /**
     * Set finalized value
     * @param bool $finalized
     * @return \StructType\VetDocument
     */
    public function setFinalized($finalized = null)
    {
        // validation for constraint: boolean
        if (!is_null($finalized) && !is_bool($finalized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($finalized)), __LINE__);
        }
        $this->finalized = $finalized;
        return $this;
    }
    /**
     * Get lastUpdateDate value
     * @return string|null
     */
    public function getLastUpdateDate()
    {
        return $this->lastUpdateDate;
    }
    /**
     * Set lastUpdateDate value
     * @param string $lastUpdateDate
     * @return \StructType\VetDocument
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->lastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get certifiedBatch value
     * @return \StructType\CertifiedBatch|null
     */
    public function getCertifiedBatch()
    {
        return $this->certifiedBatch;
    }
    /**
     * Set certifiedBatch value
     * @param \StructType\CertifiedBatch $certifiedBatch
     * @return \StructType\VetDocument
     */
    public function setCertifiedBatch(\StructType\CertifiedBatch $certifiedBatch = null)
    {
        $this->certifiedBatch = $certifiedBatch;
        return $this;
    }
    /**
     * Get certifiedConsignment value
     * @return \StructType\CertifiedConsignment|null
     */
    public function getCertifiedConsignment()
    {
        return $this->certifiedConsignment;
    }
    /**
     * Set certifiedConsignment value
     * @param \StructType\CertifiedConsignment $certifiedConsignment
     * @return \StructType\VetDocument
     */
    public function setCertifiedConsignment(\StructType\CertifiedConsignment $certifiedConsignment = null)
    {
        $this->certifiedConsignment = $certifiedConsignment;
        return $this;
    }
    /**
     * Get authentication value
     * @return \StructType\VeterinaryAuthentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\VeterinaryAuthentication $authentication
     * @return \StructType\VetDocument
     */
    public function setAuthentication(\StructType\VeterinaryAuthentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get precedingVetDocuments value
     * @return string|null
     */
    public function getPrecedingVetDocuments()
    {
        return $this->precedingVetDocuments;
    }
    /**
     * Set precedingVetDocuments value
     * @param string $precedingVetDocuments
     * @return \StructType\VetDocument
     */
    public function setPrecedingVetDocuments($precedingVetDocuments = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($precedingVetDocuments) && strlen($precedingVetDocuments) > 255) || (is_array($precedingVetDocuments) && count($precedingVetDocuments) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($precedingVetDocuments) ? strlen($precedingVetDocuments) : count($precedingVetDocuments)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($precedingVetDocuments) && !is_string($precedingVetDocuments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($precedingVetDocuments)), __LINE__);
        }
        $this->precedingVetDocuments = $precedingVetDocuments;
        return $this;
    }
    /**
     * Get referencedDocument value
     * @return \StructType\ReferencedDocument[]|null
     */
    public function getReferencedDocument()
    {
        return $this->referencedDocument;
    }
    /**
     * Set referencedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferencedDocument[] $referencedDocument
     * @return \StructType\VetDocument
     */
    public function setReferencedDocument(array $referencedDocument = array())
    {
        foreach ($referencedDocument as $vetDocumentReferencedDocumentItem) {
            // validation for constraint: itemType
            if (!$vetDocumentReferencedDocumentItem instanceof \StructType\ReferencedDocument) {
                throw new \InvalidArgumentException(sprintf('The referencedDocument property can only contain items of \StructType\ReferencedDocument, "%s" given', is_object($vetDocumentReferencedDocumentItem) ? get_class($vetDocumentReferencedDocumentItem) : gettype($vetDocumentReferencedDocumentItem)), __LINE__);
            }
        }
        $this->referencedDocument = $referencedDocument;
        return $this;
    }
    /**
     * Add item to referencedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferencedDocument $item
     * @return \StructType\VetDocument
     */
    public function addToReferencedDocument(\StructType\ReferencedDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferencedDocument) {
            throw new \InvalidArgumentException(sprintf('The referencedDocument property can only contain items of \StructType\ReferencedDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->referencedDocument[] = $item;
        return $this;
    }
    /**
     * Get statusChange value
     * @return \StructType\VetDocumentStatusChange[]|null
     */
    public function getStatusChange()
    {
        return $this->statusChange;
    }
    /**
     * Set statusChange value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocumentStatusChange[] $statusChange
     * @return \StructType\VetDocument
     */
    public function setStatusChange(array $statusChange = array())
    {
        foreach ($statusChange as $vetDocumentStatusChangeItem) {
            // validation for constraint: itemType
            if (!$vetDocumentStatusChangeItem instanceof \StructType\VetDocumentStatusChange) {
                throw new \InvalidArgumentException(sprintf('The statusChange property can only contain items of \StructType\VetDocumentStatusChange, "%s" given', is_object($vetDocumentStatusChangeItem) ? get_class($vetDocumentStatusChangeItem) : gettype($vetDocumentStatusChangeItem)), __LINE__);
            }
        }
        $this->statusChange = $statusChange;
        return $this;
    }
    /**
     * Add item to statusChange value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocumentStatusChange $item
     * @return \StructType\VetDocument
     */
    public function addToStatusChange(\StructType\VetDocumentStatusChange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocumentStatusChange) {
            throw new \InvalidArgumentException(sprintf('The statusChange property can only contain items of \StructType\VetDocumentStatusChange, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->statusChange[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VetDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
