<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnbindBusinessEntityUserResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на удаление пользователя | Пользователь, который был откреплен от ХС-заявителя.
 * @subpackage Structs
 */
class UnbindBusinessEntityUserResponse extends ApplicationResultData
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: vd:user
     * @var \StructType\User[]
     */
    public $user;
    /**
     * Constructor method for UnbindBusinessEntityUserResponse
     * @uses UnbindBusinessEntityUserResponse::setUser()
     * @param \StructType\User[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return \StructType\User[]|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $user
     * @return \StructType\UnbindBusinessEntityUserResponse
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $unbindBusinessEntityUserResponseUserItem) {
            // validation for constraint: itemType
            if (!$unbindBusinessEntityUserResponseUserItem instanceof \StructType\User) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($unbindBusinessEntityUserResponseUserItem) ? get_class($unbindBusinessEntityUserResponseUserItem) : gettype($unbindBusinessEntityUserResponseUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\UnbindBusinessEntityUserResponse
     */
    public function addToUser(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnbindBusinessEntityUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
