<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий информацию о транспорте.
 * @subpackage Structs
 */
class TransportInfo extends AbstractStructBase
{
    /**
     * The transportType
     * Meta informations extracted from the WSDL
     * - documentation: Тип транспортного средства.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportType;
    /**
     * The transportNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номера т/с.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransportNumber
     */
    public $transportNumber;
    /**
     * Constructor method for TransportInfo
     * @uses TransportInfo::setTransportType()
     * @uses TransportInfo::setTransportNumber()
     * @param string $transportType
     * @param \StructType\TransportNumber $transportNumber
     */
    public function __construct($transportType = null, \StructType\TransportNumber $transportNumber = null)
    {
        $this
            ->setTransportType($transportType)
            ->setTransportNumber($transportNumber);
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \EnumType\TransportType::valueIsValid()
     * @uses \EnumType\TransportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \StructType\TransportInfo
     */
    public function setTransportType($transportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransportType::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportType, implode(', ', \EnumType\TransportType::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get transportNumber value
     * @return \StructType\TransportNumber|null
     */
    public function getTransportNumber()
    {
        return $this->transportNumber;
    }
    /**
     * Set transportNumber value
     * @param \StructType\TransportNumber $transportNumber
     * @return \StructType\TransportInfo
     */
    public function setTransportNumber(\StructType\TransportNumber $transportNumber = null)
    {
        $this->transportNumber = $transportNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
