<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockEntry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий cведения о записи журнала продукции.
 * @subpackage Structs
 */
class StockEntry extends GenericVersioningEntity
{
    /**
     * The entryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер записи в складском журнале Меркурия. | Тип номера записи складского журнала.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d+
     * @var string
     */
    public $entryNumber;
    /**
     * The batch
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о партии продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Batch
     */
    public $batch;
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты ветеринарного сопроводительного документа, сертифицирующего партию.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetDocument;
    /**
     * The vetEventList
     * Meta informations extracted from the WSDL
     * - documentation: Список мероприятий с партией продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntryEventList
     */
    public $vetEventList;
    /**
     * The qualifier
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Тип, описывающий идентификатор.
     * - maxLength: 100
     * @var string
     */
    public $qualifier;
    /**
     * Constructor method for StockEntry
     * @uses StockEntry::setEntryNumber()
     * @uses StockEntry::setBatch()
     * @uses StockEntry::setVetDocument()
     * @uses StockEntry::setVetEventList()
     * @uses StockEntry::setQualifier()
     * @param string $entryNumber
     * @param \StructType\Batch $batch
     * @param \StructType\VetDocument[] $vetDocument
     * @param \StructType\StockEntryEventList $vetEventList
     * @param string $qualifier
     */
    public function __construct($entryNumber = null, \StructType\Batch $batch = null, array $vetDocument = array(), \StructType\StockEntryEventList $vetEventList = null, $qualifier = null)
    {
        $this
            ->setEntryNumber($entryNumber)
            ->setBatch($batch)
            ->setVetDocument($vetDocument)
            ->setVetEventList($vetEventList)
            ->setQualifier($qualifier);
    }
    /**
     * Get entryNumber value
     * @return string|null
     */
    public function getEntryNumber()
    {
        return $this->entryNumber;
    }
    /**
     * Set entryNumber value
     * @param string $entryNumber
     * @return \StructType\StockEntry
     */
    public function setEntryNumber($entryNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($entryNumber) && !preg_match('/\\d+/', $entryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d+", "%s" given', var_export($entryNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entryNumber) && !is_string($entryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entryNumber)), __LINE__);
        }
        $this->entryNumber = $entryNumber;
        return $this;
    }
    /**
     * Get batch value
     * @return \StructType\Batch|null
     */
    public function getBatch()
    {
        return $this->batch;
    }
    /**
     * Set batch value
     * @param \StructType\Batch $batch
     * @return \StructType\StockEntry
     */
    public function setBatch(\StructType\Batch $batch = null)
    {
        $this->batch = $batch;
        return $this;
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetDocument
     * @return \StructType\StockEntry
     */
    public function setVetDocument(array $vetDocument = array())
    {
        foreach ($vetDocument as $stockEntryVetDocumentItem) {
            // validation for constraint: itemType
            if (!$stockEntryVetDocumentItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($stockEntryVetDocumentItem) ? get_class($stockEntryVetDocumentItem) : gettype($stockEntryVetDocumentItem)), __LINE__);
            }
        }
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Add item to vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\StockEntry
     */
    public function addToVetDocument(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocument[] = $item;
        return $this;
    }
    /**
     * Get vetEventList value
     * @return \StructType\StockEntryEventList|null
     */
    public function getVetEventList()
    {
        return $this->vetEventList;
    }
    /**
     * Set vetEventList value
     * @param \StructType\StockEntryEventList $vetEventList
     * @return \StructType\StockEntry
     */
    public function setVetEventList(\StructType\StockEntryEventList $vetEventList = null)
    {
        $this->vetEventList = $vetEventList;
        return $this;
    }
    /**
     * Get qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->qualifier;
    }
    /**
     * Set qualifier value
     * @param string $qualifier
     * @return \StructType\StockEntry
     */
    public function setQualifier($qualifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($qualifier) && strlen($qualifier) > 100) || (is_array($qualifier) && count($qualifier) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($qualifier) ? strlen($qualifier) : count($qualifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($qualifier) && !is_string($qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualifier)), __LINE__);
        }
        $this->qualifier = $qualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
