<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentRoutePoint StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о точке маршрута
 * @subpackage Structs
 */
class ShipmentRoutePoint extends GenericEntity
{
    /**
     * The sqnId
     * Meta informations extracted from the WSDL
     * - documentation: Порядовый номер точки маршрута. | Тип, описывающий порядковый номер.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sqnId;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - documentation: Название пункта перегрузки.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Location
     */
    public $location;
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Название пункта перегрузки.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The transshipment
     * Meta informations extracted from the WSDL
     * - documentation: Признак того, осуществляется ли в данной точке перегрузка.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $transshipment;
    /**
     * The nextTransport
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о дальнейшем транспорте.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransportInfo
     */
    public $nextTransport;
    /**
     * Constructor method for ShipmentRoutePoint
     * @uses ShipmentRoutePoint::setSqnId()
     * @uses ShipmentRoutePoint::setLocation()
     * @uses ShipmentRoutePoint::setEnterprise()
     * @uses ShipmentRoutePoint::setTransshipment()
     * @uses ShipmentRoutePoint::setNextTransport()
     * @param int $sqnId
     * @param \StructType\Location $location
     * @param \StructType\Enterprise $enterprise
     * @param bool $transshipment
     * @param \StructType\TransportInfo $nextTransport
     */
    public function __construct($sqnId = null, \StructType\Location $location = null, \StructType\Enterprise $enterprise = null, $transshipment = null, \StructType\TransportInfo $nextTransport = null)
    {
        $this
            ->setSqnId($sqnId)
            ->setLocation($location)
            ->setEnterprise($enterprise)
            ->setTransshipment($transshipment)
            ->setNextTransport($nextTransport);
    }
    /**
     * Get sqnId value
     * @return int|null
     */
    public function getSqnId()
    {
        return $this->sqnId;
    }
    /**
     * Set sqnId value
     * @param int $sqnId
     * @return \StructType\ShipmentRoutePoint
     */
    public function setSqnId($sqnId = null)
    {
        // validation for constraint: int
        if (!is_null($sqnId) && !is_numeric($sqnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sqnId)), __LINE__);
        }
        $this->sqnId = $sqnId;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\Location|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\Location $location
     * @return \StructType\ShipmentRoutePoint
     */
    public function setLocation(\StructType\Location $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise|null
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\ShipmentRoutePoint
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get transshipment value
     * @return bool|null
     */
    public function getTransshipment()
    {
        return $this->transshipment;
    }
    /**
     * Set transshipment value
     * @param bool $transshipment
     * @return \StructType\ShipmentRoutePoint
     */
    public function setTransshipment($transshipment = null)
    {
        // validation for constraint: boolean
        if (!is_null($transshipment) && !is_bool($transshipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($transshipment)), __LINE__);
        }
        $this->transshipment = $transshipment;
        return $this;
    }
    /**
     * Get nextTransport value
     * @return \StructType\TransportInfo|null
     */
    public function getNextTransport()
    {
        return $this->nextTransport;
    }
    /**
     * Set nextTransport value
     * @param \StructType\TransportInfo $nextTransport
     * @return \StructType\ShipmentRoutePoint
     */
    public function setNextTransport(\StructType\TransportInfo $nextTransport = null)
    {
        $this->nextTransport = $nextTransport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentRoutePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
