<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterProductionOperationRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на оформление производственной партии. Заявка поддерживает оформление "незавершенного" производства.
 * @subpackage Structs
 */
class RegisterProductionOperationRequest extends MercuryApplicationRequest
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие, на котором совершается производственная операция.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The productionOperation
     * Meta informations extracted from the WSDL
     * - documentation: Производственная транзакция.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ProductionOperation
     */
    public $productionOperation;
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения, необходимые для оформления ветеринарного сертификата.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetDocument;
    /**
     * Constructor method for RegisterProductionOperationRequest
     * @uses RegisterProductionOperationRequest::setEnterprise()
     * @uses RegisterProductionOperationRequest::setProductionOperation()
     * @uses RegisterProductionOperationRequest::setVetDocument()
     * @param \StructType\Enterprise $enterprise
     * @param \StructType\ProductionOperation $productionOperation
     * @param \StructType\VetDocument[] $vetDocument
     */
    public function __construct(\StructType\Enterprise $enterprise = null, \StructType\ProductionOperation $productionOperation = null, array $vetDocument = array())
    {
        $this
            ->setEnterprise($enterprise)
            ->setProductionOperation($productionOperation)
            ->setVetDocument($vetDocument);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\RegisterProductionOperationRequest
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get productionOperation value
     * @return \StructType\ProductionOperation
     */
    public function getProductionOperation()
    {
        return $this->productionOperation;
    }
    /**
     * Set productionOperation value
     * @param \StructType\ProductionOperation $productionOperation
     * @return \StructType\RegisterProductionOperationRequest
     */
    public function setProductionOperation(\StructType\ProductionOperation $productionOperation = null)
    {
        $this->productionOperation = $productionOperation;
        return $this;
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetDocument
     * @return \StructType\RegisterProductionOperationRequest
     */
    public function setVetDocument(array $vetDocument = array())
    {
        foreach ($vetDocument as $registerProductionOperationRequestVetDocumentItem) {
            // validation for constraint: itemType
            if (!$registerProductionOperationRequestVetDocumentItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($registerProductionOperationRequestVetDocumentItem) ? get_class($registerProductionOperationRequestVetDocumentItem) : gettype($registerProductionOperationRequestVetDocumentItem)), __LINE__);
            }
        }
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Add item to vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\RegisterProductionOperationRequest
     */
    public function addToVetDocument(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterProductionOperationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
