<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationConditionGroup StructType
 * Meta informations extracted from the WSDL
 * - documentation: Группа условий регионализации, соблюдаемых при перевозке груза. Считается, что группа условий соблюдается (выполняется), если
 * соблюдается каждое условие, входящее в группу.
 * @subpackage Structs
 */
class RegionalizationConditionGroup extends AbstractStructBase
{
    /**
     * The condition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationCondition[]
     */
    public $condition;
    /**
     * Constructor method for RegionalizationConditionGroup
     * @uses RegionalizationConditionGroup::setCondition()
     * @param \StructType\RegionalizationCondition[] $condition
     */
    public function __construct(array $condition = array())
    {
        $this
            ->setCondition($condition);
    }
    /**
     * Get condition value
     * @return \StructType\RegionalizationCondition[]|null
     */
    public function getCondition()
    {
        return $this->condition;
    }
    /**
     * Set condition value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationCondition[] $condition
     * @return \StructType\RegionalizationConditionGroup
     */
    public function setCondition(array $condition = array())
    {
        foreach ($condition as $regionalizationConditionGroupConditionItem) {
            // validation for constraint: itemType
            if (!$regionalizationConditionGroupConditionItem instanceof \StructType\RegionalizationCondition) {
                throw new \InvalidArgumentException(sprintf('The condition property can only contain items of \StructType\RegionalizationCondition, "%s" given', is_object($regionalizationConditionGroupConditionItem) ? get_class($regionalizationConditionGroupConditionItem) : gettype($regionalizationConditionGroupConditionItem)), __LINE__);
            }
        }
        $this->condition = $condition;
        return $this;
    }
    /**
     * Add item to condition value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationCondition $item
     * @return \StructType\RegionalizationConditionGroup
     */
    public function addToCondition(\StructType\RegionalizationCondition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationCondition) {
            throw new \InvalidArgumentException(sprintf('The condition property can only contain items of \StructType\RegionalizationCondition, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->condition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationConditionGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
