<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationClause StructType
 * Meta informations extracted from the WSDL
 * - documentation: Подтверждение соблюдения условия перемещения продукции
 * @subpackage Structs
 */
class RegionalizationClause extends AbstractStructBase
{
    /**
     * The condition
     * Meta informations extracted from the WSDL
     * - documentation: Тип соблюдаемого условия перемещения партии.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RegionalizationCondition
     */
    public $condition;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: Текст (точная формулировка) соблюдаемого условия перемещения партии. | Строковый тип без ограничения максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $text;
    /**
     * Constructor method for RegionalizationClause
     * @uses RegionalizationClause::setCondition()
     * @uses RegionalizationClause::setText()
     * @param \StructType\RegionalizationCondition $condition
     * @param string $text
     */
    public function __construct(\StructType\RegionalizationCondition $condition = null, $text = null)
    {
        $this
            ->setCondition($condition)
            ->setText($text);
    }
    /**
     * Get condition value
     * @return \StructType\RegionalizationCondition
     */
    public function getCondition()
    {
        return $this->condition;
    }
    /**
     * Set condition value
     * @param \StructType\RegionalizationCondition $condition
     * @return \StructType\RegionalizationClause
     */
    public function setCondition(\StructType\RegionalizationCondition $condition = null)
    {
        $this->condition = $condition;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\RegionalizationClause
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationClause
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
