<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purpose StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий назначение груза.
 * @subpackage Structs
 */
class Purpose extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование назначение. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The forSubstandard
     * Meta informations extracted from the WSDL
     * - documentation: Назначение для некачественных грузов.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $forSubstandard;
    /**
     * Constructor method for Purpose
     * @uses Purpose::setName()
     * @uses Purpose::setForSubstandard()
     * @param string $name
     * @param bool $forSubstandard
     */
    public function __construct($name = null, $forSubstandard = null)
    {
        $this
            ->setName($name)
            ->setForSubstandard($forSubstandard);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Purpose
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get forSubstandard value
     * @return bool|null
     */
    public function getForSubstandard()
    {
        return $this->forSubstandard;
    }
    /**
     * Set forSubstandard value
     * @param bool $forSubstandard
     * @return \StructType\Purpose
     */
    public function setForSubstandard($forSubstandard = null)
    {
        // validation for constraint: boolean
        if (!is_null($forSubstandard) && !is_bool($forSubstandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forSubstandard)), __LINE__);
        }
        $this->forSubstandard = $forSubstandard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Purpose
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
