<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductionOperation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий производственную операцию.
 * @subpackage Structs
 */
class ProductionOperation extends AbstractStructBase
{
    /**
     * The operationId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор производственной транзакции (производственная смена, сутки и т.п.). Важно, что в рамках одной производственной
     * транзакции всё указанное сырьё будет соотнесено со всеми выработанными партиями продукции. Сведения о списанном в производство сырье и
     * произведенных партиях продукции для транзакции с определенным operationId могут быть переданы в нескольких запросах RegisterProductiveBatchRequest. Если
     * operationId в запросе не указан, то такая транзакция будет завершена автоматически по результам выполнения запроса. Т.е. в этом случае формат
     * запроса и поведение системы аналогичны версии Ветис API v1.3. Важно, внесенные сведения о списанном в производство сырье и произведенных
     * партиях продукции невозможно отредактировать очередным запросом RegisterProductiveBatchRequest с тем же идентификатором производственной
     * транзакции. Сведения, указанные в каждом следующем запросе будут добавлены к производственной транзакции. Запрос будет отклонен, если
     * транзакция с указанным в operationId идентификатором завершена. | Тип, описывающий идентификатор.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $operationId;
    /**
     * The rawBatch
     * Meta informations extracted from the WSDL
     * - documentation: Партия сырья.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RawBatch[]
     */
    public $rawBatch;
    /**
     * The productiveBatch
     * Meta informations extracted from the WSDL
     * - documentation: Производственная партия.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductiveBatch[]
     */
    public $productiveBatch;
    /**
     * The finalizeOperation
     * Meta informations extracted from the WSDL
     * - documentation: Флаг, который определяет, что по результатам выполнения запроса производственная транзакция с идентификатором, указанным в
     * элементе operationId, будет завершена (finalizeOperation=TRUE). После того, как транзакция завершена, внесение сведений о списанном в производство сырье
     * и произведенных партиях продукции невозможно. Флаг имеет смысл только при наличии элемента operationId в запросе, иначе игнорируется.
     * Транзакцию нельзя завершить, если для указанного сырья (rawBatch) суммарный списанный в производство объём равен нулю. Производственная
     * транзакция должна быть завершена по окончанию технологического процесса производства. Пока производственная транзакция остаётся
     * незавершенной, все соответствующие ей производственные сертификаты на выработанный объём продукции будут оставаться незакрытыми. При
     * завершении производственной транзакции все соответствующие ей производственные сертификаты на выработанный объём продукции
     * автоматически закрываются.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $finalizeOperation;
    /**
     * The appliedProcess
     * Meta informations extracted from the WSDL
     * - documentation: Технологический процесс/операция. В случае отсутствия элемента `appliedProcess` по умолчанию принимается, что в процессе
     * производственной операции происходит (в скобках указано значение элемента `appliedProcess/type`): 1. Производство (37) - если в операции
     * присутствует сырьё (`rawBatch`) и выработанная продукция (`productiveBatch`). 2. Убой (12) + Производство (37) - если в операции присутствует в качестве
     * сырья живое животное (по значению `productType`), а в качестве выработанной партии - продукция 3. Добыча (35) - если сырьё не используется, а в
     * качестве выработанной партии - живое животное. Например, для вылова рыбы. 4. Добыча (35) + Производство (37) - если сырьё не используется, а в
     * качестве выработанной партии - продукция. 5. Утилизация (101) - если сырьё присутствует в операции, а выработанной партии нет.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProcessingProcedure[]
     */
    public $appliedProcess;
    /**
     * Constructor method for ProductionOperation
     * @uses ProductionOperation::setOperationId()
     * @uses ProductionOperation::setRawBatch()
     * @uses ProductionOperation::setProductiveBatch()
     * @uses ProductionOperation::setFinalizeOperation()
     * @uses ProductionOperation::setAppliedProcess()
     * @param string $operationId
     * @param \StructType\RawBatch[] $rawBatch
     * @param \StructType\ProductiveBatch[] $productiveBatch
     * @param bool $finalizeOperation
     * @param \StructType\ProcessingProcedure[] $appliedProcess
     */
    public function __construct($operationId = null, array $rawBatch = array(), array $productiveBatch = array(), $finalizeOperation = null, array $appliedProcess = array())
    {
        $this
            ->setOperationId($operationId)
            ->setRawBatch($rawBatch)
            ->setProductiveBatch($productiveBatch)
            ->setFinalizeOperation($finalizeOperation)
            ->setAppliedProcess($appliedProcess);
    }
    /**
     * Get operationId value
     * @return string|null
     */
    public function getOperationId()
    {
        return $this->operationId;
    }
    /**
     * Set operationId value
     * @param string $operationId
     * @return \StructType\ProductionOperation
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operationId) && strlen($operationId) > 100) || (is_array($operationId) && count($operationId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($operationId) ? strlen($operationId) : count($operationId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationId)), __LINE__);
        }
        $this->operationId = $operationId;
        return $this;
    }
    /**
     * Get rawBatch value
     * @return \StructType\RawBatch[]|null
     */
    public function getRawBatch()
    {
        return $this->rawBatch;
    }
    /**
     * Set rawBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\RawBatch[] $rawBatch
     * @return \StructType\ProductionOperation
     */
    public function setRawBatch(array $rawBatch = array())
    {
        foreach ($rawBatch as $productionOperationRawBatchItem) {
            // validation for constraint: itemType
            if (!$productionOperationRawBatchItem instanceof \StructType\RawBatch) {
                throw new \InvalidArgumentException(sprintf('The rawBatch property can only contain items of \StructType\RawBatch, "%s" given', is_object($productionOperationRawBatchItem) ? get_class($productionOperationRawBatchItem) : gettype($productionOperationRawBatchItem)), __LINE__);
            }
        }
        $this->rawBatch = $rawBatch;
        return $this;
    }
    /**
     * Add item to rawBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\RawBatch $item
     * @return \StructType\ProductionOperation
     */
    public function addToRawBatch(\StructType\RawBatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RawBatch) {
            throw new \InvalidArgumentException(sprintf('The rawBatch property can only contain items of \StructType\RawBatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rawBatch[] = $item;
        return $this;
    }
    /**
     * Get productiveBatch value
     * @return \StructType\ProductiveBatch[]|null
     */
    public function getProductiveBatch()
    {
        return $this->productiveBatch;
    }
    /**
     * Set productiveBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductiveBatch[] $productiveBatch
     * @return \StructType\ProductionOperation
     */
    public function setProductiveBatch(array $productiveBatch = array())
    {
        foreach ($productiveBatch as $productionOperationProductiveBatchItem) {
            // validation for constraint: itemType
            if (!$productionOperationProductiveBatchItem instanceof \StructType\ProductiveBatch) {
                throw new \InvalidArgumentException(sprintf('The productiveBatch property can only contain items of \StructType\ProductiveBatch, "%s" given', is_object($productionOperationProductiveBatchItem) ? get_class($productionOperationProductiveBatchItem) : gettype($productionOperationProductiveBatchItem)), __LINE__);
            }
        }
        $this->productiveBatch = $productiveBatch;
        return $this;
    }
    /**
     * Add item to productiveBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductiveBatch $item
     * @return \StructType\ProductionOperation
     */
    public function addToProductiveBatch(\StructType\ProductiveBatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductiveBatch) {
            throw new \InvalidArgumentException(sprintf('The productiveBatch property can only contain items of \StructType\ProductiveBatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productiveBatch[] = $item;
        return $this;
    }
    /**
     * Get finalizeOperation value
     * @return bool|null
     */
    public function getFinalizeOperation()
    {
        return $this->finalizeOperation;
    }
    /**
     * Set finalizeOperation value
     * @param bool $finalizeOperation
     * @return \StructType\ProductionOperation
     */
    public function setFinalizeOperation($finalizeOperation = null)
    {
        // validation for constraint: boolean
        if (!is_null($finalizeOperation) && !is_bool($finalizeOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($finalizeOperation)), __LINE__);
        }
        $this->finalizeOperation = $finalizeOperation;
        return $this;
    }
    /**
     * Get appliedProcess value
     * @return \StructType\ProcessingProcedure[]|null
     */
    public function getAppliedProcess()
    {
        return $this->appliedProcess;
    }
    /**
     * Set appliedProcess value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcessingProcedure[] $appliedProcess
     * @return \StructType\ProductionOperation
     */
    public function setAppliedProcess(array $appliedProcess = array())
    {
        foreach ($appliedProcess as $productionOperationAppliedProcessItem) {
            // validation for constraint: itemType
            if (!$productionOperationAppliedProcessItem instanceof \StructType\ProcessingProcedure) {
                throw new \InvalidArgumentException(sprintf('The appliedProcess property can only contain items of \StructType\ProcessingProcedure, "%s" given', is_object($productionOperationAppliedProcessItem) ? get_class($productionOperationAppliedProcessItem) : gettype($productionOperationAppliedProcessItem)), __LINE__);
            }
        }
        $this->appliedProcess = $appliedProcess;
        return $this;
    }
    /**
     * Add item to appliedProcess value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcessingProcedure $item
     * @return \StructType\ProductionOperation
     */
    public function addToAppliedProcess(\StructType\ProcessingProcedure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProcessingProcedure) {
            throw new \InvalidArgumentException(sprintf('The appliedProcess property can only contain items of \StructType\ProcessingProcedure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->appliedProcess[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductionOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
