<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список продукции.
 * @subpackage Structs
 */
class ProductList extends EntityList
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Product[]
     */
    public $product;
    /**
     * Constructor method for ProductList
     * @uses ProductList::setProduct()
     * @param \StructType\Product[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get product value
     * @return \StructType\Product[]|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @throws \InvalidArgumentException
     * @param \StructType\Product[] $product
     * @return \StructType\ProductList
     */
    public function setProduct(array $product = array())
    {
        foreach ($product as $productListProductItem) {
            // validation for constraint: itemType
            if (!$productListProductItem instanceof \StructType\Product) {
                throw new \InvalidArgumentException(sprintf('The product property can only contain items of \StructType\Product, "%s" given', is_object($productListProductItem) ? get_class($productListProductItem) : gettype($productListProductItem)), __LINE__);
            }
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Add item to product value
     * @throws \InvalidArgumentException
     * @param \StructType\Product $item
     * @return \StructType\ProductList
     */
    public function addToProduct(\StructType\Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Product) {
            throw new \InvalidArgumentException(sprintf('The product property can only contain items of \StructType\Product, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->product[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
