<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductItem StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий cведения о наименовании продукции в соответствии с номенклатурой производителя. ProductItem – наименование
 * продукции, выпускаемое ХС-производителем (BusinessEntity) на одной или нескольких площадках (Enterprise). Для ProductItem должен быть указан
 * ХС-собственник торговой марки (ТМ). По умолчанию, им является ХС-производитель. Если одно наименование продукции (ТМ) производится одним
 * ХС-производителем на нескольких площадках, в реестре должна быть зарегистрирована строго одна запись. Если одно наименование продукции
 * (ТМ), принадлежащее одному ХС-собственнику ТМ, производится несколькими ХС-производителями, в реестре должно быть зарегистрировано
 * несколько записей по одной на каждого ХС-производителя.
 * @subpackage Structs
 */
class ProductItem extends GenericVersioningEntity
{
    /**
     * The globalID
     * Meta informations extracted from the WSDL
     * - documentation: Global Trade Identification Number (GTIN) - уникальный идентификационный номер продукции производителя. В отличие от поля code GTIN уникален для
     * продукции всех производителей. Уникальность обеспечивается использованием префикса компании-производителя в составе GTIN. См.
     * http://www.gs1.org/gtin | Тип для представления Global Trade Identification Number всех форматов: GTIN-8, GTIN-12, GTIN-13, GTIN-14
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 14
     * - minLength: 8
     * @var string
     */
    public $globalID;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование продукции. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Артикул (код) продукции в соответствии с внутренним кодификатором производителя. Артикул продукции должен быть уникальным в
     * пределах одного производителя. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $code;
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - documentation: Тип продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Продукция.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Product
     */
    public $product;
    /**
     * The subProduct
     * Meta informations extracted from the WSDL
     * - documentation: Вид продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SubProduct
     */
    public $subProduct;
    /**
     * The correspondsToGost
     * Meta informations extracted from the WSDL
     * - documentation: Соответствует ли ГОСТу.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $correspondsToGost;
    /**
     * The gost
     * Meta informations extracted from the WSDL
     * - documentation: ГОСТ. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $gost;
    /**
     * The producer
     * Meta informations extracted from the WSDL
     * - documentation: ХС-производитель продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $producer;
    /**
     * The tmOwner
     * Meta informations extracted from the WSDL
     * - documentation: ХС-собственник торговой марки.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $tmOwner;
    /**
     * The producing
     * Meta informations extracted from the WSDL
     * - documentation: Список площадок, на которых выпускается данная продукция.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductItemProducing[]
     */
    public $producing;
    /**
     * The packaging
     * Meta informations extracted from the WSDL
     * - documentation: Фасовка.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Packaging
     */
    public $packaging;
    /**
     * The isPublic
     * Meta informations extracted from the WSDL
     * - documentation: Позиция справочника доступна для просмотра другим участникам.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isPublic;
    /**
     * Constructor method for ProductItem
     * @uses ProductItem::setGlobalID()
     * @uses ProductItem::setName()
     * @uses ProductItem::setCode()
     * @uses ProductItem::setProductType()
     * @uses ProductItem::setProduct()
     * @uses ProductItem::setSubProduct()
     * @uses ProductItem::setCorrespondsToGost()
     * @uses ProductItem::setGost()
     * @uses ProductItem::setProducer()
     * @uses ProductItem::setTmOwner()
     * @uses ProductItem::setProducing()
     * @uses ProductItem::setPackaging()
     * @uses ProductItem::setIsPublic()
     * @param string $globalID
     * @param string $name
     * @param string $code
     * @param string $productType
     * @param \StructType\Product $product
     * @param \StructType\SubProduct $subProduct
     * @param bool $correspondsToGost
     * @param string $gost
     * @param \StructType\BusinessEntity $producer
     * @param \StructType\BusinessEntity $tmOwner
     * @param \StructType\ProductItemProducing[] $producing
     * @param \StructType\Packaging $packaging
     * @param bool $isPublic
     */
    public function __construct($globalID = null, $name = null, $code = null, $productType = null, \StructType\Product $product = null, \StructType\SubProduct $subProduct = null, $correspondsToGost = null, $gost = null, \StructType\BusinessEntity $producer = null, \StructType\BusinessEntity $tmOwner = null, array $producing = array(), \StructType\Packaging $packaging = null, $isPublic = null)
    {
        $this
            ->setGlobalID($globalID)
            ->setName($name)
            ->setCode($code)
            ->setProductType($productType)
            ->setProduct($product)
            ->setSubProduct($subProduct)
            ->setCorrespondsToGost($correspondsToGost)
            ->setGost($gost)
            ->setProducer($producer)
            ->setTmOwner($tmOwner)
            ->setProducing($producing)
            ->setPackaging($packaging)
            ->setIsPublic($isPublic);
    }
    /**
     * Get globalID value
     * @return string|null
     */
    public function getGlobalID()
    {
        return $this->globalID;
    }
    /**
     * Set globalID value
     * @param string $globalID
     * @return \StructType\ProductItem
     */
    public function setGlobalID($globalID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($globalID) && strlen($globalID) > 14) || (is_array($globalID) && count($globalID) > 14)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 14 element(s) or a scalar of 14 character(s) at most, "%d" length given', is_scalar($globalID) ? strlen($globalID) : count($globalID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($globalID) && strlen($globalID) < 8) || (is_array($globalID) && count($globalID) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($globalID) && !is_string($globalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($globalID)), __LINE__);
        }
        $this->globalID = $globalID;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ProductItem
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ProductItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 255) || (is_array($code) && count($code) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\ProductItem
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\Product|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\Product $product
     * @return \StructType\ProductItem
     */
    public function setProduct(\StructType\Product $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get subProduct value
     * @return \StructType\SubProduct|null
     */
    public function getSubProduct()
    {
        return $this->subProduct;
    }
    /**
     * Set subProduct value
     * @param \StructType\SubProduct $subProduct
     * @return \StructType\ProductItem
     */
    public function setSubProduct(\StructType\SubProduct $subProduct = null)
    {
        $this->subProduct = $subProduct;
        return $this;
    }
    /**
     * Get correspondsToGost value
     * @return bool|null
     */
    public function getCorrespondsToGost()
    {
        return $this->correspondsToGost;
    }
    /**
     * Set correspondsToGost value
     * @param bool $correspondsToGost
     * @return \StructType\ProductItem
     */
    public function setCorrespondsToGost($correspondsToGost = null)
    {
        // validation for constraint: boolean
        if (!is_null($correspondsToGost) && !is_bool($correspondsToGost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($correspondsToGost)), __LINE__);
        }
        $this->correspondsToGost = $correspondsToGost;
        return $this;
    }
    /**
     * Get gost value
     * @return string|null
     */
    public function getGost()
    {
        return $this->gost;
    }
    /**
     * Set gost value
     * @param string $gost
     * @return \StructType\ProductItem
     */
    public function setGost($gost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($gost) && strlen($gost) > 255) || (is_array($gost) && count($gost) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($gost) ? strlen($gost) : count($gost)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gost) && !is_string($gost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gost)), __LINE__);
        }
        $this->gost = $gost;
        return $this;
    }
    /**
     * Get producer value
     * @return \StructType\BusinessEntity|null
     */
    public function getProducer()
    {
        return $this->producer;
    }
    /**
     * Set producer value
     * @param \StructType\BusinessEntity $producer
     * @return \StructType\ProductItem
     */
    public function setProducer(\StructType\BusinessEntity $producer = null)
    {
        $this->producer = $producer;
        return $this;
    }
    /**
     * Get tmOwner value
     * @return \StructType\BusinessEntity|null
     */
    public function getTmOwner()
    {
        return $this->tmOwner;
    }
    /**
     * Set tmOwner value
     * @param \StructType\BusinessEntity $tmOwner
     * @return \StructType\ProductItem
     */
    public function setTmOwner(\StructType\BusinessEntity $tmOwner = null)
    {
        $this->tmOwner = $tmOwner;
        return $this;
    }
    /**
     * Get producing value
     * @return \StructType\ProductItemProducing[]|null
     */
    public function getProducing()
    {
        return $this->producing;
    }
    /**
     * Set producing value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItemProducing[] $producing
     * @return \StructType\ProductItem
     */
    public function setProducing(array $producing = array())
    {
        foreach ($producing as $productItemProducingItem) {
            // validation for constraint: itemType
            if (!$productItemProducingItem instanceof \StructType\ProductItemProducing) {
                throw new \InvalidArgumentException(sprintf('The producing property can only contain items of \StructType\ProductItemProducing, "%s" given', is_object($productItemProducingItem) ? get_class($productItemProducingItem) : gettype($productItemProducingItem)), __LINE__);
            }
        }
        $this->producing = $producing;
        return $this;
    }
    /**
     * Add item to producing value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItemProducing $item
     * @return \StructType\ProductItem
     */
    public function addToProducing(\StructType\ProductItemProducing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductItemProducing) {
            throw new \InvalidArgumentException(sprintf('The producing property can only contain items of \StructType\ProductItemProducing, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->producing[] = $item;
        return $this;
    }
    /**
     * Get packaging value
     * @return \StructType\Packaging|null
     */
    public function getPackaging()
    {
        return $this->packaging;
    }
    /**
     * Set packaging value
     * @param \StructType\Packaging $packaging
     * @return \StructType\ProductItem
     */
    public function setPackaging(\StructType\Packaging $packaging = null)
    {
        $this->packaging = $packaging;
        return $this;
    }
    /**
     * Get isPublic value
     * @return bool|null
     */
    public function getIsPublic()
    {
        return $this->isPublic;
    }
    /**
     * Set isPublic value
     * @param bool $isPublic
     * @return \StructType\ProductItem
     */
    public function setIsPublic($isPublic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPublic) && !is_bool($isPublic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPublic)), __LINE__);
        }
        $this->isPublic = $isPublic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
