<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProducerList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список производителей продукции.
 * @subpackage Structs
 */
class ProducerList extends AbstractStructBase
{
    /**
     * The producer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Producer[]
     */
    public $producer;
    /**
     * Constructor method for ProducerList
     * @uses ProducerList::setProducer()
     * @param \StructType\Producer[] $producer
     */
    public function __construct(array $producer = array())
    {
        $this
            ->setProducer($producer);
    }
    /**
     * Get producer value
     * @return \StructType\Producer[]|null
     */
    public function getProducer()
    {
        return $this->producer;
    }
    /**
     * Set producer value
     * @throws \InvalidArgumentException
     * @param \StructType\Producer[] $producer
     * @return \StructType\ProducerList
     */
    public function setProducer(array $producer = array())
    {
        foreach ($producer as $producerListProducerItem) {
            // validation for constraint: itemType
            if (!$producerListProducerItem instanceof \StructType\Producer) {
                throw new \InvalidArgumentException(sprintf('The producer property can only contain items of \StructType\Producer, "%s" given', is_object($producerListProducerItem) ? get_class($producerListProducerItem) : gettype($producerListProducerItem)), __LINE__);
            }
        }
        $this->producer = $producer;
        return $this;
    }
    /**
     * Add item to producer value
     * @throws \InvalidArgumentException
     * @param \StructType\Producer $item
     * @return \StructType\ProducerList
     */
    public function addToProducer(\StructType\Producer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Producer) {
            throw new \InvalidArgumentException(sprintf('The producer property can only contain items of \StructType\Producer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->producer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProducerList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
