<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingProcedure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий производственный процесс.
 * @subpackage Structs
 */
class ProcessingProcedure extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип производственного процесса.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The startDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала процесса.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDateTime;
    /**
     * The endDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания процесса.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endDateTime;
    /**
     * Constructor method for ProcessingProcedure
     * @uses ProcessingProcedure::setType()
     * @uses ProcessingProcedure::setStartDateTime()
     * @uses ProcessingProcedure::setEndDateTime()
     * @param string $type
     * @param string $startDateTime
     * @param string $endDateTime
     */
    public function __construct($type = null, $startDateTime = null, $endDateTime = null)
    {
        $this
            ->setType($type)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ProcessingProcedureType::valueIsValid()
     * @uses \EnumType\ProcessingProcedureType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ProcessingProcedure
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProcessingProcedureType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ProcessingProcedureType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get startDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->startDateTime;
    }
    /**
     * Set startDateTime value
     * @param string $startDateTime
     * @return \StructType\ProcessingProcedure
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTime)), __LINE__);
        }
        $this->startDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get endDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->endDateTime;
    }
    /**
     * Set endDateTime value
     * @param string $endDateTime
     * @return \StructType\ProcessingProcedure
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTime)), __LINE__);
        }
        $this->endDateTime = $endDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessingProcedure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
