<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessIncomingDeliveryResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат заявки на оформление входящей партии.
 * @subpackage Structs
 */
class ProcessIncomingDeliveryResponse extends ApplicationResultData
{
    /**
     * The stockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о созданных записи(ях) журнала продукции. Передаётся сокращенный набор сведений о записи журнала: uuid guid active last status
     * createDate updateDate entryNumber batch/productType batch/product batch/subProduct batch/productItem batch/volume batch/unit batch/dateOfProduction batch/expiryDate batch/batchID batch/perishable batch/lowGradeCargo @qualifier Атрибут
     * @qualifier заполняется значением, указанным в атрибуте запроса accompanyingForms/vetCertificate/@qualifier для соответствующего входящего ВСД. По умолчанию,
     * значение @qualifier совпадает с идентификатором сертификата accompanyingForms/vetCertificate/uuid
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StockEntry[]
     */
    public $stockEntry;
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о ветеринарных сертификатах: погашенном и возвратном. Для возвратных ВСД передаётся полный набор сведений, для
     * погашенных ВСД -- сокращенный: uuid vetDForm vetDType vetDStatus finalized lastUpdateDate statusChange @qualifier Для возвратных ВСД атрибут @qualifier заполняется значением,
     * указанным в атрибуте запроса accompanyingForms/vetCertificate/@qualifier для соответствующего входящего ВСД. По умолчанию, значение @qualifier совпадает с
     * идентификатором сертификата accompanyingForms/vetCertificate/uuid
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetDocument;
    /**
     * Constructor method for ProcessIncomingDeliveryResponse
     * @uses ProcessIncomingDeliveryResponse::setStockEntry()
     * @uses ProcessIncomingDeliveryResponse::setVetDocument()
     * @param \StructType\StockEntry[] $stockEntry
     * @param \StructType\VetDocument[] $vetDocument
     */
    public function __construct(array $stockEntry = array(), array $vetDocument = array())
    {
        $this
            ->setStockEntry($stockEntry)
            ->setVetDocument($vetDocument);
    }
    /**
     * Get stockEntry value
     * @return \StructType\StockEntry[]|null
     */
    public function getStockEntry()
    {
        return $this->stockEntry;
    }
    /**
     * Set stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $stockEntry
     * @return \StructType\ProcessIncomingDeliveryResponse
     */
    public function setStockEntry(array $stockEntry = array())
    {
        foreach ($stockEntry as $processIncomingDeliveryResponseStockEntryItem) {
            // validation for constraint: itemType
            if (!$processIncomingDeliveryResponseStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($processIncomingDeliveryResponseStockEntryItem) ? get_class($processIncomingDeliveryResponseStockEntryItem) : gettype($processIncomingDeliveryResponseStockEntryItem)), __LINE__);
            }
        }
        $this->stockEntry = $stockEntry;
        return $this;
    }
    /**
     * Add item to stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\ProcessIncomingDeliveryResponse
     */
    public function addToStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockEntry[] = $item;
        return $this;
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetDocument
     * @return \StructType\ProcessIncomingDeliveryResponse
     */
    public function setVetDocument(array $vetDocument = array())
    {
        foreach ($vetDocument as $processIncomingDeliveryResponseVetDocumentItem) {
            // validation for constraint: itemType
            if (!$processIncomingDeliveryResponseVetDocumentItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($processIncomingDeliveryResponseVetDocumentItem) ? get_class($processIncomingDeliveryResponseVetDocumentItem) : gettype($processIncomingDeliveryResponseVetDocumentItem)), __LINE__);
            }
        }
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Add item to vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\ProcessIncomingDeliveryResponse
     */
    public function addToVetDocument(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessIncomingDeliveryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
