<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessIncomingConsignmentResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат заявки на оформление входящей партии.
 * @subpackage Structs
 */
class ProcessIncomingConsignmentResponse extends ApplicationResultData
{
    /**
     * The stockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о созданных записи(ях) журнала продукции.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StockEntry[]
     */
    public $stockEntry;
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о ветеринарных сертификатах: погашенном и возвратном.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetDocument;
    /**
     * Constructor method for ProcessIncomingConsignmentResponse
     * @uses ProcessIncomingConsignmentResponse::setStockEntry()
     * @uses ProcessIncomingConsignmentResponse::setVetDocument()
     * @param \StructType\StockEntry[] $stockEntry
     * @param \StructType\VetDocument[] $vetDocument
     */
    public function __construct(array $stockEntry = array(), array $vetDocument = array())
    {
        $this
            ->setStockEntry($stockEntry)
            ->setVetDocument($vetDocument);
    }
    /**
     * Get stockEntry value
     * @return \StructType\StockEntry[]|null
     */
    public function getStockEntry()
    {
        return $this->stockEntry;
    }
    /**
     * Set stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $stockEntry
     * @return \StructType\ProcessIncomingConsignmentResponse
     */
    public function setStockEntry(array $stockEntry = array())
    {
        foreach ($stockEntry as $processIncomingConsignmentResponseStockEntryItem) {
            // validation for constraint: itemType
            if (!$processIncomingConsignmentResponseStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($processIncomingConsignmentResponseStockEntryItem) ? get_class($processIncomingConsignmentResponseStockEntryItem) : gettype($processIncomingConsignmentResponseStockEntryItem)), __LINE__);
            }
        }
        $this->stockEntry = $stockEntry;
        return $this;
    }
    /**
     * Add item to stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\ProcessIncomingConsignmentResponse
     */
    public function addToStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockEntry[] = $item;
        return $this;
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetDocument
     * @return \StructType\ProcessIncomingConsignmentResponse
     */
    public function setVetDocument(array $vetDocument = array())
    {
        foreach ($vetDocument as $processIncomingConsignmentResponseVetDocumentItem) {
            // validation for constraint: itemType
            if (!$processIncomingConsignmentResponseVetDocumentItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($processIncomingConsignmentResponseVetDocumentItem) ? get_class($processIncomingConsignmentResponseVetDocumentItem) : gettype($processIncomingConsignmentResponseVetDocumentItem)), __LINE__);
            }
        }
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Add item to vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\ProcessIncomingConsignmentResponse
     */
    public function addToVetDocument(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessIncomingConsignmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
