<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessIncomingConsignmentRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на оформление входящей партии.
 * @subpackage Structs
 */
class ProcessIncomingConsignmentRequest extends MercuryApplicationRequest
{
    /**
     * The delivery
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о поставке.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Delivery
     */
    public $delivery;
    /**
     * The deliveryFacts
     * Meta informations extracted from the WSDL
     * - documentation: Результаты приёмки.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DeliveryFactList
     */
    public $deliveryFacts;
    /**
     * The discrepancyReport
     * Meta informations extracted from the WSDL
     * - documentation: Акт о несоответствии.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DiscrepancyReport[]
     */
    public $discrepancyReport;
    /**
     * The returnedDelivery
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о возврате продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Delivery
     */
    public $returnedDelivery;
    /**
     * Constructor method for ProcessIncomingConsignmentRequest
     * @uses ProcessIncomingConsignmentRequest::setDelivery()
     * @uses ProcessIncomingConsignmentRequest::setDeliveryFacts()
     * @uses ProcessIncomingConsignmentRequest::setDiscrepancyReport()
     * @uses ProcessIncomingConsignmentRequest::setReturnedDelivery()
     * @param \StructType\Delivery $delivery
     * @param \StructType\DeliveryFactList $deliveryFacts
     * @param \StructType\DiscrepancyReport[] $discrepancyReport
     * @param \StructType\Delivery $returnedDelivery
     */
    public function __construct(\StructType\Delivery $delivery = null, \StructType\DeliveryFactList $deliveryFacts = null, array $discrepancyReport = array(), \StructType\Delivery $returnedDelivery = null)
    {
        $this
            ->setDelivery($delivery)
            ->setDeliveryFacts($deliveryFacts)
            ->setDiscrepancyReport($discrepancyReport)
            ->setReturnedDelivery($returnedDelivery);
    }
    /**
     * Get delivery value
     * @return \StructType\Delivery
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @param \StructType\Delivery $delivery
     * @return \StructType\ProcessIncomingConsignmentRequest
     */
    public function setDelivery(\StructType\Delivery $delivery = null)
    {
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Get deliveryFacts value
     * @return \StructType\DeliveryFactList
     */
    public function getDeliveryFacts()
    {
        return $this->deliveryFacts;
    }
    /**
     * Set deliveryFacts value
     * @param \StructType\DeliveryFactList $deliveryFacts
     * @return \StructType\ProcessIncomingConsignmentRequest
     */
    public function setDeliveryFacts(\StructType\DeliveryFactList $deliveryFacts = null)
    {
        $this->deliveryFacts = $deliveryFacts;
        return $this;
    }
    /**
     * Get discrepancyReport value
     * @return \StructType\DiscrepancyReport[]|null
     */
    public function getDiscrepancyReport()
    {
        return $this->discrepancyReport;
    }
    /**
     * Set discrepancyReport value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscrepancyReport[] $discrepancyReport
     * @return \StructType\ProcessIncomingConsignmentRequest
     */
    public function setDiscrepancyReport(array $discrepancyReport = array())
    {
        foreach ($discrepancyReport as $processIncomingConsignmentRequestDiscrepancyReportItem) {
            // validation for constraint: itemType
            if (!$processIncomingConsignmentRequestDiscrepancyReportItem instanceof \StructType\DiscrepancyReport) {
                throw new \InvalidArgumentException(sprintf('The discrepancyReport property can only contain items of \StructType\DiscrepancyReport, "%s" given', is_object($processIncomingConsignmentRequestDiscrepancyReportItem) ? get_class($processIncomingConsignmentRequestDiscrepancyReportItem) : gettype($processIncomingConsignmentRequestDiscrepancyReportItem)), __LINE__);
            }
        }
        $this->discrepancyReport = $discrepancyReport;
        return $this;
    }
    /**
     * Add item to discrepancyReport value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscrepancyReport $item
     * @return \StructType\ProcessIncomingConsignmentRequest
     */
    public function addToDiscrepancyReport(\StructType\DiscrepancyReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscrepancyReport) {
            throw new \InvalidArgumentException(sprintf('The discrepancyReport property can only contain items of \StructType\DiscrepancyReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discrepancyReport[] = $item;
        return $this;
    }
    /**
     * Get returnedDelivery value
     * @return \StructType\Delivery|null
     */
    public function getReturnedDelivery()
    {
        return $this->returnedDelivery;
    }
    /**
     * Set returnedDelivery value
     * @param \StructType\Delivery $returnedDelivery
     * @return \StructType\ProcessIncomingConsignmentRequest
     */
    public function setReturnedDelivery(\StructType\Delivery $returnedDelivery = null)
    {
        $this->returnedDelivery = $returnedDelivery;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessIncomingConsignmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
