<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareOutgoingConsignmentResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат заявки на оформление транспортной партии.
 * @subpackage Structs
 */
class PrepareOutgoingConsignmentResponse extends ApplicationResultData
{
    /**
     * The stockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о измененных записи(ях) журнала продукции.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StockEntry[]
     */
    public $stockEntry;
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об оформленном или погашенном ветеринарном сертификате.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetDocument;
    /**
     * Constructor method for PrepareOutgoingConsignmentResponse
     * @uses PrepareOutgoingConsignmentResponse::setStockEntry()
     * @uses PrepareOutgoingConsignmentResponse::setVetDocument()
     * @param \StructType\StockEntry[] $stockEntry
     * @param \StructType\VetDocument[] $vetDocument
     */
    public function __construct(array $stockEntry = array(), array $vetDocument = array())
    {
        $this
            ->setStockEntry($stockEntry)
            ->setVetDocument($vetDocument);
    }
    /**
     * Get stockEntry value
     * @return \StructType\StockEntry[]|null
     */
    public function getStockEntry()
    {
        return $this->stockEntry;
    }
    /**
     * Set stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $stockEntry
     * @return \StructType\PrepareOutgoingConsignmentResponse
     */
    public function setStockEntry(array $stockEntry = array())
    {
        foreach ($stockEntry as $prepareOutgoingConsignmentResponseStockEntryItem) {
            // validation for constraint: itemType
            if (!$prepareOutgoingConsignmentResponseStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($prepareOutgoingConsignmentResponseStockEntryItem) ? get_class($prepareOutgoingConsignmentResponseStockEntryItem) : gettype($prepareOutgoingConsignmentResponseStockEntryItem)), __LINE__);
            }
        }
        $this->stockEntry = $stockEntry;
        return $this;
    }
    /**
     * Add item to stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\PrepareOutgoingConsignmentResponse
     */
    public function addToStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockEntry[] = $item;
        return $this;
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetDocument
     * @return \StructType\PrepareOutgoingConsignmentResponse
     */
    public function setVetDocument(array $vetDocument = array())
    {
        foreach ($vetDocument as $prepareOutgoingConsignmentResponseVetDocumentItem) {
            // validation for constraint: itemType
            if (!$prepareOutgoingConsignmentResponseVetDocumentItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($prepareOutgoingConsignmentResponseVetDocumentItem) ? get_class($prepareOutgoingConsignmentResponseVetDocumentItem) : gettype($prepareOutgoingConsignmentResponseVetDocumentItem)), __LINE__);
            }
        }
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Add item to vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\PrepareOutgoingConsignmentResponse
     */
    public function addToVetDocument(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepareOutgoingConsignmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
