<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Packaging StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий вариант фасовки продукции.
 * @subpackage Structs
 */
class Packaging extends AbstractStructBase
{
    /**
     * The packagingType
     * Meta informations extracted from the WSDL
     * - documentation: Тип упаковки.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PackingType
     */
    public $packagingType;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - documentation: Количество единиц упаковки.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объём единицы упаковки товара. | Вещественный тип с ограничением числа знаков после запятой.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - fractionDigits: 6
     * @var float
     */
    public $volume;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - documentation: Единица измерения объёма единицы упаковки товара.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unit
     */
    public $unit;
    /**
     * Constructor method for Packaging
     * @uses Packaging::setPackagingType()
     * @uses Packaging::setQuantity()
     * @uses Packaging::setVolume()
     * @uses Packaging::setUnit()
     * @param \StructType\PackingType $packagingType
     * @param int $quantity
     * @param float $volume
     * @param \StructType\Unit $unit
     */
    public function __construct(\StructType\PackingType $packagingType = null, $quantity = null, $volume = null, \StructType\Unit $unit = null)
    {
        $this
            ->setPackagingType($packagingType)
            ->setQuantity($quantity)
            ->setVolume($volume)
            ->setUnit($unit);
    }
    /**
     * Get packagingType value
     * @return \StructType\PackingType
     */
    public function getPackagingType()
    {
        return $this->packagingType;
    }
    /**
     * Set packagingType value
     * @param \StructType\PackingType $packagingType
     * @return \StructType\Packaging
     */
    public function setPackagingType(\StructType\PackingType $packagingType = null)
    {
        $this->packagingType = $packagingType;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\Packaging
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \StructType\Packaging
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($volume) && strlen(substr($volume, strpos($volume, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($volume, strpos($volume, '.') + 1))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\Unit|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param \StructType\Unit $unit
     * @return \StructType\Packaging
     */
    public function setUnit(\StructType\Unit $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Packaging
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
