<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Locality StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип населенного пункта (город, поселок, деревня и прочие).
 * @subpackage Structs
 */
class Locality extends AddressObjectView
{
    /**
     * The regionGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор рениона, к которому относится данный населенный пункт. | Тип, описывающий уникальный идентификатор
     * любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $regionGuid;
    /**
     * The districtGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор района, к которому относится данный населенный пункт. | Тип, описывающий уникальный идентификатор
     * любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $districtGuid;
    /**
     * The cityGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор города, к которому относится данный населенный пункт. | Тип, описывающий уникальный идентификатор
     * любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $cityGuid;
    /**
     * Constructor method for Locality
     * @uses Locality::setRegionGuid()
     * @uses Locality::setDistrictGuid()
     * @uses Locality::setCityGuid()
     * @param string $regionGuid
     * @param string $districtGuid
     * @param string $cityGuid
     */
    public function __construct($regionGuid = null, $districtGuid = null, $cityGuid = null)
    {
        $this
            ->setRegionGuid($regionGuid)
            ->setDistrictGuid($districtGuid)
            ->setCityGuid($cityGuid);
    }
    /**
     * Get regionGuid value
     * @return string|null
     */
    public function getRegionGuid()
    {
        return $this->regionGuid;
    }
    /**
     * Set regionGuid value
     * @param string $regionGuid
     * @return \StructType\Locality
     */
    public function setRegionGuid($regionGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($regionGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $regionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($regionGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regionGuid) && !is_string($regionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionGuid)), __LINE__);
        }
        $this->regionGuid = $regionGuid;
        return $this;
    }
    /**
     * Get districtGuid value
     * @return string|null
     */
    public function getDistrictGuid()
    {
        return $this->districtGuid;
    }
    /**
     * Set districtGuid value
     * @param string $districtGuid
     * @return \StructType\Locality
     */
    public function setDistrictGuid($districtGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($districtGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $districtGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($districtGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($districtGuid) && !is_string($districtGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($districtGuid)), __LINE__);
        }
        $this->districtGuid = $districtGuid;
        return $this;
    }
    /**
     * Get cityGuid value
     * @return string|null
     */
    public function getCityGuid()
    {
        return $this->cityGuid;
    }
    /**
     * Set cityGuid value
     * @param string $cityGuid
     * @return \StructType\Locality
     */
    public function setCityGuid($cityGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cityGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $cityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($cityGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cityGuid) && !is_string($cityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityGuid)), __LINE__);
        }
        $this->cityGuid = $cityGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Locality
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
