<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVetDocumentListRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на получение списка записей ветсертификатов. | Параметры запрашиваемого списка. | Тип ветсертификата. | Статус
 * ветсертификата. | Период дат оформления документа. Соответствует полю issueDate документа в результирующем списке. Максимальная длина
 * интервала -- 31 день. | Отправитель для транспортного ВСД. Фильтрация осуществляется по глобальному идентификатору ХС (consignor/businessEntity/guid) и
 * площадки (consignor/enterprise/guid). Если производится поиск по производственным документам (установлен фильтр vetDocumentType = PRODUCTIVE), поле consignor
 * игнорируется. | Связанный документ. Поддерживается поиск по связанным документам с отношением (relationshipType) равным 1 и 6, поддерживаемые
 * типы документов: 1-5 (транспортный документ). Для документа обязательными к заполнению являются поля тип (type), номер (issueNumber) и дата (issueDate).
 * При поиске по связанному документу обязательно заполнение фильтра vetDocumentType. | Идентификатор предприятия, по которому производится
 * поиск записей. В результирующий список попадут (в общем случае, если не установлено других критериев отбора): 1) Транспортные ВСД, для
 * которых ХС-отправитель соответствует заявителю (issuer), предприятие-отправитель -- указанному идентификатору (enterpriseGuid). 2) Транспортные
 * ВСД, для которых ХС-получатель соответствует заявителю (issuer), предприятие-получатель -- указанному идентификатору (enterpriseGuid). 3)
 * Производственные ВСД, для которых ХС-производитель соответствует заявителю (issuer), предприятие-производитель -- указанному
 * идентификатору (enterpriseGuid).
 * @subpackage Structs
 */
class GetVetDocumentListRequest extends MercuryApplicationRequest
{
    /**
     * The enterpriseGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: dt:enterpriseGuid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $enterpriseGuid;
    /**
     * The listOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: bs:listOptions
     * @var \StructType\ListOptions
     */
    public $listOptions;
    /**
     * The vetDocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:vetDocumentType
     * @var string
     */
    public $vetDocumentType;
    /**
     * The vetDocumentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:vetDocumentStatus
     * @var string
     */
    public $vetDocumentStatus;
    /**
     * The issueDateInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:issueDateInterval
     * @var \StructType\DateInterval
     */
    public $issueDateInterval;
    /**
     * The consignor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:consignor
     * @var \StructType\BusinessMember
     */
    public $consignor;
    /**
     * The referencedDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:referencedDocument
     * @var \StructType\ReferencedDocument
     */
    public $referencedDocument;
    /**
     * Constructor method for GetVetDocumentListRequest
     * @uses GetVetDocumentListRequest::setEnterpriseGuid()
     * @uses GetVetDocumentListRequest::setListOptions()
     * @uses GetVetDocumentListRequest::setVetDocumentType()
     * @uses GetVetDocumentListRequest::setVetDocumentStatus()
     * @uses GetVetDocumentListRequest::setIssueDateInterval()
     * @uses GetVetDocumentListRequest::setConsignor()
     * @uses GetVetDocumentListRequest::setReferencedDocument()
     * @param string $enterpriseGuid
     * @param \StructType\ListOptions $listOptions
     * @param string $vetDocumentType
     * @param string $vetDocumentStatus
     * @param \StructType\DateInterval $issueDateInterval
     * @param \StructType\BusinessMember $consignor
     * @param \StructType\ReferencedDocument $referencedDocument
     */
    public function __construct($enterpriseGuid = null, \StructType\ListOptions $listOptions = null, $vetDocumentType = null, $vetDocumentStatus = null, \StructType\DateInterval $issueDateInterval = null, \StructType\BusinessMember $consignor = null, \StructType\ReferencedDocument $referencedDocument = null)
    {
        $this
            ->setEnterpriseGuid($enterpriseGuid)
            ->setListOptions($listOptions)
            ->setVetDocumentType($vetDocumentType)
            ->setVetDocumentStatus($vetDocumentStatus)
            ->setIssueDateInterval($issueDateInterval)
            ->setConsignor($consignor)
            ->setReferencedDocument($referencedDocument);
    }
    /**
     * Get enterpriseGuid value
     * @return string
     */
    public function getEnterpriseGuid()
    {
        return $this->enterpriseGuid;
    }
    /**
     * Set enterpriseGuid value
     * @param string $enterpriseGuid
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setEnterpriseGuid($enterpriseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($enterpriseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseGuid) && !is_string($enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseGuid)), __LINE__);
        }
        $this->enterpriseGuid = $enterpriseGuid;
        return $this;
    }
    /**
     * Get listOptions value
     * @return \StructType\ListOptions|null
     */
    public function getListOptions()
    {
        return $this->listOptions;
    }
    /**
     * Set listOptions value
     * @param \StructType\ListOptions $listOptions
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setListOptions(\StructType\ListOptions $listOptions = null)
    {
        $this->listOptions = $listOptions;
        return $this;
    }
    /**
     * Get vetDocumentType value
     * @return string|null
     */
    public function getVetDocumentType()
    {
        return $this->vetDocumentType;
    }
    /**
     * Set vetDocumentType value
     * @uses \EnumType\VetDocumentType::valueIsValid()
     * @uses \EnumType\VetDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDocumentType
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setVetDocumentType($vetDocumentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentType::valueIsValid($vetDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDocumentType, implode(', ', \EnumType\VetDocumentType::getValidValues())), __LINE__);
        }
        $this->vetDocumentType = $vetDocumentType;
        return $this;
    }
    /**
     * Get vetDocumentStatus value
     * @return string|null
     */
    public function getVetDocumentStatus()
    {
        return $this->vetDocumentStatus;
    }
    /**
     * Set vetDocumentStatus value
     * @uses \EnumType\VetDocumentStatus::valueIsValid()
     * @uses \EnumType\VetDocumentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDocumentStatus
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setVetDocumentStatus($vetDocumentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentStatus::valueIsValid($vetDocumentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDocumentStatus, implode(', ', \EnumType\VetDocumentStatus::getValidValues())), __LINE__);
        }
        $this->vetDocumentStatus = $vetDocumentStatus;
        return $this;
    }
    /**
     * Get issueDateInterval value
     * @return \StructType\DateInterval|null
     */
    public function getIssueDateInterval()
    {
        return $this->issueDateInterval;
    }
    /**
     * Set issueDateInterval value
     * @param \StructType\DateInterval $issueDateInterval
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setIssueDateInterval(\StructType\DateInterval $issueDateInterval = null)
    {
        $this->issueDateInterval = $issueDateInterval;
        return $this;
    }
    /**
     * Get consignor value
     * @return \StructType\BusinessMember|null
     */
    public function getConsignor()
    {
        return $this->consignor;
    }
    /**
     * Set consignor value
     * @param \StructType\BusinessMember $consignor
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setConsignor(\StructType\BusinessMember $consignor = null)
    {
        $this->consignor = $consignor;
        return $this;
    }
    /**
     * Get referencedDocument value
     * @return \StructType\ReferencedDocument|null
     */
    public function getReferencedDocument()
    {
        return $this->referencedDocument;
    }
    /**
     * Set referencedDocument value
     * @param \StructType\ReferencedDocument $referencedDocument
     * @return \StructType\GetVetDocumentListRequest
     */
    public function setReferencedDocument(\StructType\ReferencedDocument $referencedDocument = null)
    {
        $this->referencedDocument = $referencedDocument;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVetDocumentListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
