<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStockEntryVersionListRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на получение всех версий по идентификатору записи журнала. | Параметры запрашиваемого списка. | Идентификатор записи, по
 * которому производится поиск. | Идентификатор предприятия, по которому производится поиск записи.
 * @subpackage Structs
 */
class GetStockEntryVersionListRequest extends MercuryApplicationRequest
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: bs:guid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $guid;
    /**
     * The enterpriseGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: dt:enterpriseGuid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $enterpriseGuid;
    /**
     * The listOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: bs:listOptions
     * @var \StructType\ListOptions
     */
    public $listOptions;
    /**
     * Constructor method for GetStockEntryVersionListRequest
     * @uses GetStockEntryVersionListRequest::setGuid()
     * @uses GetStockEntryVersionListRequest::setEnterpriseGuid()
     * @uses GetStockEntryVersionListRequest::setListOptions()
     * @param string $guid
     * @param string $enterpriseGuid
     * @param \StructType\ListOptions $listOptions
     */
    public function __construct($guid = null, $enterpriseGuid = null, \StructType\ListOptions $listOptions = null)
    {
        $this
            ->setGuid($guid)
            ->setEnterpriseGuid($enterpriseGuid)
            ->setListOptions($listOptions);
    }
    /**
     * Get guid value
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\GetStockEntryVersionListRequest
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($guid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($guid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get enterpriseGuid value
     * @return string
     */
    public function getEnterpriseGuid()
    {
        return $this->enterpriseGuid;
    }
    /**
     * Set enterpriseGuid value
     * @param string $enterpriseGuid
     * @return \StructType\GetStockEntryVersionListRequest
     */
    public function setEnterpriseGuid($enterpriseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($enterpriseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseGuid) && !is_string($enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseGuid)), __LINE__);
        }
        $this->enterpriseGuid = $enterpriseGuid;
        return $this;
    }
    /**
     * Get listOptions value
     * @return \StructType\ListOptions|null
     */
    public function getListOptions()
    {
        return $this->listOptions;
    }
    /**
     * Set listOptions value
     * @param \StructType\ListOptions $listOptions
     * @return \StructType\GetStockEntryVersionListRequest
     */
    public function setListOptions(\StructType\ListOptions $listOptions = null)
    {
        $this->listOptions = $listOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStockEntryVersionListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
