<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStockEntryListRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на получение списка актуальных записей журнала. | Параметры запрашиваемого списка. | Идентификатор предприятия, по
 * которому производится поиск записей.
 * @subpackage Structs
 */
class GetStockEntryListRequest extends MercuryApplicationRequest
{
    /**
     * The enterpriseGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: dt:enterpriseGuid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $enterpriseGuid;
    /**
     * The listOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: bs:listOptions
     * @var \StructType\ListOptions
     */
    public $listOptions;
    /**
     * The searchPattern
     * Meta informations extracted from the WSDL
     * - documentation: Шаблон поиска записей складского журнала.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntrySearchPattern
     */
    public $searchPattern;
    /**
     * Constructor method for GetStockEntryListRequest
     * @uses GetStockEntryListRequest::setEnterpriseGuid()
     * @uses GetStockEntryListRequest::setListOptions()
     * @uses GetStockEntryListRequest::setSearchPattern()
     * @param string $enterpriseGuid
     * @param \StructType\ListOptions $listOptions
     * @param \StructType\StockEntrySearchPattern $searchPattern
     */
    public function __construct($enterpriseGuid = null, \StructType\ListOptions $listOptions = null, \StructType\StockEntrySearchPattern $searchPattern = null)
    {
        $this
            ->setEnterpriseGuid($enterpriseGuid)
            ->setListOptions($listOptions)
            ->setSearchPattern($searchPattern);
    }
    /**
     * Get enterpriseGuid value
     * @return string
     */
    public function getEnterpriseGuid()
    {
        return $this->enterpriseGuid;
    }
    /**
     * Set enterpriseGuid value
     * @param string $enterpriseGuid
     * @return \StructType\GetStockEntryListRequest
     */
    public function setEnterpriseGuid($enterpriseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($enterpriseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseGuid) && !is_string($enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseGuid)), __LINE__);
        }
        $this->enterpriseGuid = $enterpriseGuid;
        return $this;
    }
    /**
     * Get listOptions value
     * @return \StructType\ListOptions|null
     */
    public function getListOptions()
    {
        return $this->listOptions;
    }
    /**
     * Set listOptions value
     * @param \StructType\ListOptions $listOptions
     * @return \StructType\GetStockEntryListRequest
     */
    public function setListOptions(\StructType\ListOptions $listOptions = null)
    {
        $this->listOptions = $listOptions;
        return $this;
    }
    /**
     * Get searchPattern value
     * @return \StructType\StockEntrySearchPattern|null
     */
    public function getSearchPattern()
    {
        return $this->searchPattern;
    }
    /**
     * Set searchPattern value
     * @param \StructType\StockEntrySearchPattern $searchPattern
     * @return \StructType\GetStockEntryListRequest
     */
    public function setSearchPattern(\StructType\StockEntrySearchPattern $searchPattern = null)
    {
        $this->searchPattern = $searchPattern;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStockEntryListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
