<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStockEntryByGuidRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на получение записи журнала по глобальному идентификатору. | Идентификатор записи, по которому производится поиск. |
 * Идентификатор предприятия, по которому производится поиск записи.
 * @subpackage Structs
 */
class GetStockEntryByGuidRequest extends MercuryApplicationRequest
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: bs:guid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $guid;
    /**
     * The enterpriseGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: dt:enterpriseGuid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $enterpriseGuid;
    /**
     * Constructor method for GetStockEntryByGuidRequest
     * @uses GetStockEntryByGuidRequest::setGuid()
     * @uses GetStockEntryByGuidRequest::setEnterpriseGuid()
     * @param string $guid
     * @param string $enterpriseGuid
     */
    public function __construct($guid = null, $enterpriseGuid = null)
    {
        $this
            ->setGuid($guid)
            ->setEnterpriseGuid($enterpriseGuid);
    }
    /**
     * Get guid value
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\GetStockEntryByGuidRequest
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($guid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($guid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get enterpriseGuid value
     * @return string
     */
    public function getEnterpriseGuid()
    {
        return $this->enterpriseGuid;
    }
    /**
     * Set enterpriseGuid value
     * @param string $enterpriseGuid
     * @return \StructType\GetStockEntryByGuidRequest
     */
    public function setEnterpriseGuid($enterpriseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($enterpriseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseGuid) && !is_string($enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseGuid)), __LINE__);
        }
        $this->enterpriseGuid = $enterpriseGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStockEntryByGuidRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
