<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описываюший ошибки.
 * @subpackage Structs
 */
class FaultInfo extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $message;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Error[]
     */
    public $error;
    /**
     * Constructor method for FaultInfo
     * @uses FaultInfo::setMessage()
     * @uses FaultInfo::setError()
     * @param string $message
     * @param \StructType\Error[] $error
     */
    public function __construct($message = null, array $error = array())
    {
        $this
            ->setMessage($message)
            ->setError($error);
    }
    /**
     * Get message value
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\FaultInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get error value
     * @return \StructType\Error[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error[] $error
     * @return \StructType\FaultInfo
     */
    public function setError(array $error = array())
    {
        foreach ($error as $faultInfoErrorItem) {
            // validation for constraint: itemType
            if (!$faultInfoErrorItem instanceof \StructType\Error) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \StructType\Error, "%s" given', is_object($faultInfoErrorItem) ? get_class($faultInfoErrorItem) : gettype($faultInfoErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error $item
     * @return \StructType\FaultInfo
     */
    public function addToError(\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \StructType\Error, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaultInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
