<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $code;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The qualifier
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Тип, описывающий идентификатор.
     * - maxLength: 100
     * @var string
     */
    public $qualifier;
    /**
     * Constructor method for Error
     * @uses Error::setCode()
     * @uses Error::set_()
     * @uses Error::setQualifier()
     * @param string $code
     * @param string $_
     * @param string $qualifier
     */
    public function __construct($code = null, $_ = null, $qualifier = null)
    {
        $this
            ->setCode($code)
            ->set_($_)
            ->setQualifier($qualifier);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Error
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Error
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->qualifier;
    }
    /**
     * Set qualifier value
     * @param string $qualifier
     * @return \StructType\Error
     */
    public function setQualifier($qualifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($qualifier) && strlen($qualifier) > 100) || (is_array($qualifier) && count($qualifier) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($qualifier) ? strlen($qualifier) : count($qualifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($qualifier) && !is_string($qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualifier)), __LINE__);
        }
        $this->qualifier = $qualifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
