<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Базовый тип для описания списков сущностей.
 * @subpackage Structs
 */
class EntityList extends AbstractStructBase
{
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - documentation: Размер списка, передаваемого в ответе на запрос.
     * - use: optional
     * @var int
     */
    public $count;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - documentation: Размер всего списка, удовлетворяющего запросу.
     * - use: optional
     * @var int
     */
    public $total;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - documentation: Смещение первого элемента передаваемого списка во всем списке результатов, удовлетворяющих запросу.
     * - use: optional
     * @var int
     */
    public $offset;
    /**
     * The hasMore
     * Meta informations extracted from the WSDL
     * - documentation: Признак того, что передаваемая часть (страница) списка, удовлетворяющего запросу, не является последней. Для списка в ответе
     * сервиса обязательным является наличие одного из двух атрибутов: total или hasMore
     * - use: optional
     * @var bool
     */
    public $hasMore;
    /**
     * Constructor method for EntityList
     * @uses EntityList::setCount()
     * @uses EntityList::setTotal()
     * @uses EntityList::setOffset()
     * @uses EntityList::setHasMore()
     * @param int $count
     * @param int $total
     * @param int $offset
     * @param bool $hasMore
     */
    public function __construct($count = null, $total = null, $offset = null, $hasMore = null)
    {
        $this
            ->setCount($count)
            ->setTotal($total)
            ->setOffset($offset)
            ->setHasMore($hasMore);
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\EntityList
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\EntityList
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\EntityList
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get hasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->hasMore;
    }
    /**
     * Set hasMore value
     * @param bool $hasMore
     * @return \StructType\EntityList
     */
    public function setHasMore($hasMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMore) && !is_bool($hasMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMore)), __LINE__);
        }
        $this->hasMore = $hasMore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
