<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterpriseActivityList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список видов деятельности.
 * @subpackage Structs
 */
class EnterpriseActivityList extends EntityList
{
    /**
     * The activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EnterpriseActivity[]
     */
    public $activity;
    /**
     * Constructor method for EnterpriseActivityList
     * @uses EnterpriseActivityList::setActivity()
     * @param \StructType\EnterpriseActivity[] $activity
     */
    public function __construct(array $activity = array())
    {
        $this
            ->setActivity($activity);
    }
    /**
     * Get activity value
     * @return \StructType\EnterpriseActivity[]|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @throws \InvalidArgumentException
     * @param \StructType\EnterpriseActivity[] $activity
     * @return \StructType\EnterpriseActivityList
     */
    public function setActivity(array $activity = array())
    {
        foreach ($activity as $enterpriseActivityListActivityItem) {
            // validation for constraint: itemType
            if (!$enterpriseActivityListActivityItem instanceof \StructType\EnterpriseActivity) {
                throw new \InvalidArgumentException(sprintf('The activity property can only contain items of \StructType\EnterpriseActivity, "%s" given', is_object($enterpriseActivityListActivityItem) ? get_class($enterpriseActivityListActivityItem) : gettype($enterpriseActivityListActivityItem)), __LINE__);
            }
        }
        $this->activity = $activity;
        return $this;
    }
    /**
     * Add item to activity value
     * @throws \InvalidArgumentException
     * @param \StructType\EnterpriseActivity $item
     * @return \StructType\EnterpriseActivityList
     */
    public function addToActivity(\StructType\EnterpriseActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EnterpriseActivity) {
            throw new \InvalidArgumentException(sprintf('The activity property can only contain items of \StructType\EnterpriseActivity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->activity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnterpriseActivityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
