<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistrictList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип-обертка для списка районов.
 * @subpackage Structs
 */
class DistrictList extends EntityList
{
    /**
     * The district
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\District[]
     */
    public $district;
    /**
     * Constructor method for DistrictList
     * @uses DistrictList::setDistrict()
     * @param \StructType\District[] $district
     */
    public function __construct(array $district = array())
    {
        $this
            ->setDistrict($district);
    }
    /**
     * Get district value
     * @return \StructType\District[]|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @throws \InvalidArgumentException
     * @param \StructType\District[] $district
     * @return \StructType\DistrictList
     */
    public function setDistrict(array $district = array())
    {
        foreach ($district as $districtListDistrictItem) {
            // validation for constraint: itemType
            if (!$districtListDistrictItem instanceof \StructType\District) {
                throw new \InvalidArgumentException(sprintf('The district property can only contain items of \StructType\District, "%s" given', is_object($districtListDistrictItem) ? get_class($districtListDistrictItem) : gettype($districtListDistrictItem)), __LINE__);
            }
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Add item to district value
     * @throws \InvalidArgumentException
     * @param \StructType\District $item
     * @return \StructType\DistrictList
     */
    public function addToDistrict(\StructType\District $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\District) {
            throw new \InvalidArgumentException(sprintf('The district property can only contain items of \StructType\District, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->district[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistrictList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
