<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscrepancyReport StructType
 * Meta informations extracted from the WSDL
 * - documentation: Акт о несоответствии.
 * @subpackage Structs
 */
class DiscrepancyReport extends Document
{
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: Причина несоответствия.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DiscrepancyReason
     */
    public $reason;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Детальное описание.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for DiscrepancyReport
     * @uses DiscrepancyReport::setReason()
     * @uses DiscrepancyReport::setDescription()
     * @param \StructType\DiscrepancyReason $reason
     * @param string $description
     */
    public function __construct(\StructType\DiscrepancyReason $reason = null, $description = null)
    {
        $this
            ->setReason($reason)
            ->setDescription($description);
    }
    /**
     * Get reason value
     * @return \StructType\DiscrepancyReason|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param \StructType\DiscrepancyReason $reason
     * @return \StructType\DiscrepancyReport
     */
    public function setReason(\StructType\DiscrepancyReason $reason = null)
    {
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DiscrepancyReport
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscrepancyReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
