<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryInspection StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контроль поставки (документарный, ветеринарный)
 * @subpackage Structs
 */
class DeliveryInspection extends AbstractStructBase
{
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $result;
    /**
     * The responsible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $responsible;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип без ограничения максимальной длины.
     * @var string
     */
    public $info;
    /**
     * Constructor method for DeliveryInspection
     * @uses DeliveryInspection::setResult()
     * @uses DeliveryInspection::setResponsible()
     * @uses DeliveryInspection::setInfo()
     * @param string $result
     * @param \StructType\User $responsible
     * @param string $info
     */
    public function __construct($result = null, \StructType\User $responsible = null, $info = null)
    {
        $this
            ->setResult($result)
            ->setResponsible($responsible)
            ->setInfo($info);
    }
    /**
     * Get result value
     * @return string
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @uses \EnumType\DeliveryInspectionResult::valueIsValid()
     * @uses \EnumType\DeliveryInspectionResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \StructType\DeliveryInspection
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryInspectionResult::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $result, implode(', ', \EnumType\DeliveryInspectionResult::getValidValues())), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get responsible value
     * @return \StructType\User|null
     */
    public function getResponsible()
    {
        return $this->responsible;
    }
    /**
     * Set responsible value
     * @param \StructType\User $responsible
     * @return \StructType\DeliveryInspection
     */
    public function setResponsible(\StructType\User $responsible = null)
    {
        $this->responsible = $responsible;
        return $this;
    }
    /**
     * Get info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \StructType\DeliveryInspection
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryInspection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
