<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateInterval StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, с помощью которого задается временной интервал.
 * @subpackage Structs
 */
class DateInterval extends AbstractStructBase
{
    /**
     * The beginDate
     * Meta informations extracted from the WSDL
     * - documentation: Начало временного интервала.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: Конец временного интервала.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for DateInterval
     * @uses DateInterval::setBeginDate()
     * @uses DateInterval::setEndDate()
     * @param string $beginDate
     * @param string $endDate
     */
    public function __construct($beginDate = null, $endDate = null)
    {
        $this
            ->setBeginDate($beginDate)
            ->setEndDate($endDate);
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \StructType\DateInterval
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\DateInterval
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateInterval
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
