<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsignmentDocumentList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Пакет сопроводительных документов
 * @subpackage Structs
 */
class ConsignmentDocumentList extends AbstractStructBase
{
    /**
     * The waybill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Waybill
     */
    public $waybill;
    /**
     * The vetCertificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetCertificate;
    /**
     * The relatedDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReferencedDocument[]
     */
    public $relatedDocument;
    /**
     * Constructor method for ConsignmentDocumentList
     * @uses ConsignmentDocumentList::setWaybill()
     * @uses ConsignmentDocumentList::setVetCertificate()
     * @uses ConsignmentDocumentList::setRelatedDocument()
     * @param \StructType\Waybill $waybill
     * @param \StructType\VetDocument[] $vetCertificate
     * @param \StructType\ReferencedDocument[] $relatedDocument
     */
    public function __construct(\StructType\Waybill $waybill = null, array $vetCertificate = array(), array $relatedDocument = array())
    {
        $this
            ->setWaybill($waybill)
            ->setVetCertificate($vetCertificate)
            ->setRelatedDocument($relatedDocument);
    }
    /**
     * Get waybill value
     * @return \StructType\Waybill|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param \StructType\Waybill $waybill
     * @return \StructType\ConsignmentDocumentList
     */
    public function setWaybill(\StructType\Waybill $waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
    /**
     * Get vetCertificate value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetCertificate()
    {
        return $this->vetCertificate;
    }
    /**
     * Set vetCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetCertificate
     * @return \StructType\ConsignmentDocumentList
     */
    public function setVetCertificate(array $vetCertificate = array())
    {
        foreach ($vetCertificate as $consignmentDocumentListVetCertificateItem) {
            // validation for constraint: itemType
            if (!$consignmentDocumentListVetCertificateItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetCertificate property can only contain items of \StructType\VetDocument, "%s" given', is_object($consignmentDocumentListVetCertificateItem) ? get_class($consignmentDocumentListVetCertificateItem) : gettype($consignmentDocumentListVetCertificateItem)), __LINE__);
            }
        }
        $this->vetCertificate = $vetCertificate;
        return $this;
    }
    /**
     * Add item to vetCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\ConsignmentDocumentList
     */
    public function addToVetCertificate(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetCertificate property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetCertificate[] = $item;
        return $this;
    }
    /**
     * Get relatedDocument value
     * @return \StructType\ReferencedDocument[]|null
     */
    public function getRelatedDocument()
    {
        return $this->relatedDocument;
    }
    /**
     * Set relatedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferencedDocument[] $relatedDocument
     * @return \StructType\ConsignmentDocumentList
     */
    public function setRelatedDocument(array $relatedDocument = array())
    {
        foreach ($relatedDocument as $consignmentDocumentListRelatedDocumentItem) {
            // validation for constraint: itemType
            if (!$consignmentDocumentListRelatedDocumentItem instanceof \StructType\ReferencedDocument) {
                throw new \InvalidArgumentException(sprintf('The relatedDocument property can only contain items of \StructType\ReferencedDocument, "%s" given', is_object($consignmentDocumentListRelatedDocumentItem) ? get_class($consignmentDocumentListRelatedDocumentItem) : gettype($consignmentDocumentListRelatedDocumentItem)), __LINE__);
            }
        }
        $this->relatedDocument = $relatedDocument;
        return $this;
    }
    /**
     * Add item to relatedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferencedDocument $item
     * @return \StructType\ConsignmentDocumentList
     */
    public function addToRelatedDocument(\StructType\ReferencedDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferencedDocument) {
            throw new \InvalidArgumentException(sprintf('The relatedDocument property can only contain items of \StructType\ReferencedDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsignmentDocumentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
