<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consignment StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий транспортную партию груза.
 * @subpackage Structs
 */
class Consignment extends Batch
{
    /**
     * The sourceStockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Запись журнала, из которой формируется транспортная партия.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntry
     */
    public $sourceStockEntry;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор, определяющий consignment в запросе. Должен быть указан, если запрос содержит несколько элементов consignment.
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * The partOf
     * Meta informations extracted from the WSDL
     * - documentation: Ссылка на consignment в разделе delivery запроса. Должен быть указан, если запрос содержит несколько элементов consignment.
     * - use: optional
     * @var string
     */
    public $partOf;
    /**
     * Constructor method for Consignment
     * @uses Consignment::setSourceStockEntry()
     * @uses Consignment::setId()
     * @uses Consignment::setPartOf()
     * @param \StructType\StockEntry $sourceStockEntry
     * @param string $id
     * @param string $partOf
     */
    public function __construct(\StructType\StockEntry $sourceStockEntry = null, $id = null, $partOf = null)
    {
        $this
            ->setSourceStockEntry($sourceStockEntry)
            ->setId($id)
            ->setPartOf($partOf);
    }
    /**
     * Get sourceStockEntry value
     * @return \StructType\StockEntry|null
     */
    public function getSourceStockEntry()
    {
        return $this->sourceStockEntry;
    }
    /**
     * Set sourceStockEntry value
     * @param \StructType\StockEntry $sourceStockEntry
     * @return \StructType\Consignment
     */
    public function setSourceStockEntry(\StructType\StockEntry $sourceStockEntry = null)
    {
        $this->sourceStockEntry = $sourceStockEntry;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Consignment
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get partOf value
     * @return string|null
     */
    public function getPartOf()
    {
        return $this->partOf;
    }
    /**
     * Set partOf value
     * @param string $partOf
     * @return \StructType\Consignment
     */
    public function setPartOf($partOf = null)
    {
        // validation for constraint: string
        if (!is_null($partOf) && !is_string($partOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partOf)), __LINE__);
        }
        $this->partOf = $partOf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Consignment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
